/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.wls.DeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.container.StageMode;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.contributor.ArtifactDeploymentContributor;
import com.xebialabs.deployit.plugin.wls.step.DeleteArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.UploadArtifactStep;
import com.xebialabs.overthere.OverthereFile;
import java.util.HashSet;
import java.util.Map;

@Metadata(virtual=true, description="Base class for all deployeds meant to contain Applications")
@Placeholders
public class ExtensibleDeployedArtifact<D extends DeployableArtifact>
extends PythonManagedDeployed<D, WlsContainer>
implements DerivedArtifact<DeployableArtifact> {
    static final int NO_RETIREMENT_TIMEOUT = -1;
    public static final Type DEPLOYED_SHARED_LIB_WAR = Type.valueOf((String)"wls", (String)"SharedLibraryWarModule");
    @Property(defaultValue="Stage", required=false, description="Indicates whether the artifact will be deployed as staged or nostage mode")
    private StageMode stageMode;
    @Property(required=false, description="Absolute directory path where the artifact will be uploaded and used by the servers for nostage deployment mode")
    private String stagingDirectory;
    @Property(required=true, defaultValue="CLASSIC", description="Indicates what redeployment strategy to use for upgrading the application")
    private DeploymentStrategy redeploymentStrategy;
    @Property(required=false, description="Indicates wither this artifact is to be deployed as a versioned application", category="Versioning")
    private boolean versioned = false;
    @Property(required=false, defaultValue="-1", description="Timeout interval (in secs) before the previous application version is undeployed for side by side redeployment strategy", category="Versioning")
    private int retireTimeout;
    @Property(required=false, category="Versioning")
    private String versionIdentifier;
    @Property(required=false, defaultValue="true", category="Versioning", description="If set, the 'versionIdentifier' property is managed by the plugin. Any value explicitly set for 'versionIdentifier' is ignored")
    private boolean automaticVersioning;
    @Property(hidden=true, defaultValue="id, name, type, deployable, properties, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, destroyScript, destroyVerb, destroyOrder, startScript, startVerb, startOrder, stopScript, stopVerb, stopOrder, deploymentStrategy, placeholders, file, redeploymentStrategy, securityPermissions, inheritPermissions, exposeDeployedApplication, stopRetiredApplicationOrder, undeployRetiredApplicationOrder, isRunningRetryWaitInterval, wlstPath, libraryScripts, discoverOrder, deploymentOrder ")
    private String standardPropertiesNotToExpose;
    @Property(category="Placeholders", description="A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required=false)
    private Map<String, String> placeholders = Maps.newHashMap();
    @Property(hidden=true, required=false, description="Python script invoked to deploy this Java EE artifact")
    private String createScript;
    @Property(hidden=true, defaultValue="Deploy")
    private String createVerb;
    @Property(hidden=true, defaultValue="70")
    private int createOrder;
    @Property(hidden=true, required=false, description="Python script invoked to upgrade this Java EE artifact")
    private String modifyScript;
    @Property(hidden=true, defaultValue="Upgrade")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="60")
    private int modifyOrder;
    @Property(hidden=true, required=false, description="Python script invoked to undeploy this Java EE artifact")
    private String destroyScript;
    @Property(hidden=true, defaultValue="Undeploy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="30")
    private int destroyOrder;
    @Property(hidden=true, defaultValue="98")
    private int undeployRetiredApplicationOrder;
    @Property(hidden=true, defaultValue="95")
    private int stopRetiredApplicationOrder;
    @Property(hidden=true, required=false, description="Python script invoked to start this Java EE artifact")
    private String startScript;
    @Property(hidden=true, defaultValue="Start")
    private String startVerb;
    @Property(hidden=true, defaultValue="90")
    private int startOrder;
    @Property(hidden=true, required=false, description="Python script invoked to stop this Java EE artifact")
    private String stopScript;
    @Property(hidden=true, defaultValue="Stop")
    private String stopVerb;
    @Property(hidden=true, defaultValue="10")
    private int stopOrder;
    private OverthereFile derivedFile;
    private Map<String, Object> pythonVars = Maps.newHashMap();

    @Create
    public void deployArtifact(DeploymentPlanningContext result, Delta delta) {
        this.deployWeblogicArtifact(result, delta);
        this.setRetireTimeout(-1);
    }

    void deployWeblogicArtifact(DeploymentPlanningContext result, Delta delta) {
        this.validateDeployedFields();
        this.handleCopyArtifact(result);
        this.addStep(result, this.createOrder, this.createScript, this.createVerb, ExtensibleDeployedArtifact.checkpoint((Delta)delta, (Operation)Operation.CREATE));
    }

    @Modify
    public void modifyArtifact(DeploymentPlanningContext result, Delta delta) {
        if (!Strings.isNullOrEmpty((String)this.modifyScript)) {
            this.addStep(result, this.modifyOrder, this.modifyScript, this.modifyVerb, ExtensibleDeployedArtifact.checkpoint((Delta)delta));
        } else {
            ExtensibleDeployedArtifact previous = (ExtensibleDeployedArtifact)delta.getPrevious();
            ExtensibleDeployedArtifact current = (ExtensibleDeployedArtifact)delta.getDeployed();
            this.validateModifiedDeployed(previous, current);
            previous.destroyArtifact(result, delta);
            current.deployWeblogicArtifact(result, delta);
        }
        if (this.getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE) {
            Integer retireTimeout = this.getRetireTimeout();
            ArtifactDeploymentContributor.setWaitStepInterval(result, retireTimeout.intValue());
        } else {
            this.setProperty("retireTimeout", -1);
        }
    }

    @Destroy
    public void destroyArtifact(DeploymentPlanningContext result, Delta delta) {
        int order = this.destroyOrder;
        if (delta.getOperation() == Operation.MODIFY && ((ExtensibleDeployedArtifact)delta.getDeployed()).getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE) {
            order = this.undeployRetiredApplicationOrder;
        }
        this.addStep(result, order, this.destroyScript, this.destroyVerb, false, ExtensibleDeployedArtifact.checkpoint((Delta)delta, (Operation)Operation.DESTROY));
        this.handleDeleteArtifact(result, this.destroyOrder);
    }

    private boolean isStartOrStopOperationRequired() {
        if (DEPLOYED_SHARED_LIB_WAR.equals((Object)this.getType())) {
            return false;
        }
        return this.getRedeploymentStrategy() != DeploymentStrategy.STOP_START;
    }

    @Create
    @Modify
    public void startApplication(DeploymentPlanningContext result) {
        if (this.isStartOrStopOperationRequired()) {
            this.addStep(result, this.startOrder, this.startScript, this.startVerb, false);
        }
    }

    @Modify
    public void stopApplicationForModifedArtifact(DeploymentPlanningContext result, Delta delta) {
        if (!this.isStartOrStopOperationRequired()) {
            return;
        }
        ExtensibleDeployedArtifact previous = (ExtensibleDeployedArtifact)delta.getPrevious();
        if (this.getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE) {
            previous.addStep(result, this.stopRetiredApplicationOrder, this.stopScript, this.stopVerb, false);
        } else {
            previous.addStep(result, this.stopOrder, this.stopScript, this.stopVerb, false);
        }
    }

    @Destroy
    public void stopApplication(DeploymentPlanningContext result) {
        if (this.isStartOrStopOperationRequired()) {
            this.addStep(result, this.stopOrder, this.stopScript, this.stopVerb, false);
        }
    }

    protected String getDescription(String verb) {
        if (Artifact.class.isAssignableFrom(((DeployableArtifact)this.getDeployable()).getClass())) {
            return String.format("%s %s on %s", verb, ((DeployableArtifact)this.getDeployable()).getFile().getName(), ((WlsContainer)this.getContainer()).getName());
        }
        return super.getDescription(verb);
    }

    protected Map<String, Object> getPythonVars(DeployedApplication deployedApplication) {
        this.pythonVars.putAll(super.getPythonVars(deployedApplication));
        return this.pythonVars;
    }

    private void validateModifiedDeployed(ExtensibleDeployedArtifact<DeployableArtifact> previous, ExtensibleDeployedArtifact<DeployableArtifact> current) {
        String currentStagingDir;
        String previousStagingDir;
        this.validateDeployedFields();
        if (this.isNoStageMode() && (previousStagingDir = previous.getStagingDirectory()).equals(currentStagingDir = current.getStagingDirectory())) {
            throw new RuntimeException("Can't deploy a new version to " + currentStagingDir + ". This is same as the previous deployment nostage directory!");
        }
    }

    private void validateDeployedFields() {
        if (this.isNoStageMode()) {
            if (Strings.isNullOrEmpty((String)this.getStagingDirectory())) {
                throw new RuntimeException("Staging directory shouldn't be blank");
            }
            if (((WlsContainer)this.getContainer()).getHosts() == null) {
                throw new RuntimeException("NoStage deployment: the target " + this.getContainer() + " contains no hosts, check your repository");
            }
        }
        if (this.getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE && !this.isVersioned()) {
            throw new RuntimeException("SIDE_BY_SIDE deployment strategy is only applicable for versioned deployment");
        }
    }

    protected void handleCopyArtifact(DeploymentPlanningContext result) {
        if (this.isNoStageMode()) {
            HashSet<Host> hosts = new HashSet<Host>(((WlsContainer)this.getContainer()).getHosts());
            hosts.add(((WlsContainer)this.getContainer()).getDomain().getHost());
            String remoteDestinationFilename = this.getRemoteDestinationFilename((Host)hosts.iterator().next());
            for (Host h : hosts) {
                ArtifactDeploymentContributor.addUploadArtifactStep(result, new UploadArtifactStep(68, h, (Artifact)this.getDeployable(), remoteDestinationFilename));
            }
            this.pythonVars.put("remoteDestinationFilename", remoteDestinationFilename);
        }
    }

    protected void handleDeleteArtifact(DeploymentPlanningContext result, int order) {
        if (this.isNoStageMode()) {
            HashSet<Host> hosts = new HashSet<Host>(((WlsContainer)this.getContainer()).getHosts());
            hosts.add(((WlsContainer)this.getContainer()).getDomain().getHost());
            for (Host h : hosts) {
                ArtifactDeploymentContributor.addDeleteArtifactStep(result, new DeleteArtifactStep(order, h, this.getRemoteDestinationFilename(h)));
            }
        }
    }

    private String getRemoteDestinationFilename(Host host) {
        return this.getStagingDirectory() + host.getOs().getFileSeparator() + ((DeployableArtifact)this.getDeployable()).getFile().getName();
    }

    private boolean isNoStageMode() {
        return this.getStageMode().equals((Object)StageMode.NoStage);
    }

    public StageMode getStageMode() {
        return this.stageMode;
    }

    public void setStageMode(StageMode stageMode) {
        this.stageMode = stageMode;
    }

    public String getStagingDirectory() {
        return this.stagingDirectory;
    }

    public void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = stagingDirectory;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public void setVersioned(boolean versioned) {
        this.versioned = versioned;
    }

    public boolean isAutomaticVersioning() {
        return this.automaticVersioning;
    }

    public void setAutomaticVersioning(boolean automaticVersioning) {
        this.automaticVersioning = automaticVersioning;
    }

    public DeploymentStrategy getRedeploymentStrategy() {
        return this.redeploymentStrategy;
    }

    public int getRetireTimeout() {
        return this.retireTimeout;
    }

    public void setRetireTimeout(int retireTimeout) {
        this.retireTimeout = retireTimeout;
    }

    public void setRedeploymentStrategy(DeploymentStrategy deploymentStrategy) {
        this.redeploymentStrategy = deploymentStrategy;
    }

    public OverthereFile getFile() {
        return this.derivedFile;
    }

    public void setFile(OverthereFile file) {
        this.derivedFile = file;
    }

    public DeployableArtifact getSourceArtifact() {
        return (DeployableArtifact)this.getDeployable();
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }
}

