package com.xebialabs.deployit.plugin.wls.contributor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArchiveArtifact;
import com.xebialabs.deployit.plugin.wls.DeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.ResourceTargetRestartPolicy;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.Resource;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;

import static com.google.common.collect.Iterables.concat;
import static com.google.common.collect.Iterables.transform;
import static com.google.common.collect.Lists.newArrayList;

@SuppressWarnings("unused")
public class WlsContainerStopStartContributor {

    @Contributor
    @SuppressWarnings("unused")
    public void stopContainers(Deltas deltas, DeploymentPlanningContext result) {
        result.addSteps(concat(transform(gatherTargets(deltas.getDeltas()), new Function<WlsContainer, List<Step>>() {
            @Override
            public List<Step> apply(final WlsContainer container) {
                return container.getStopSteps(container.getStopOrder());
            }
        })));
    }

    @Contributor
    @SuppressWarnings("unused")
    public void startContainers(Deltas deltas, DeploymentPlanningContext result) {
        result.addSteps(concat(transform(gatherTargets(deltas.getDeltas()), new Function<WlsContainer, List<Step>>() {
            @Override
            public List<Step> apply(final WlsContainer container) {
                return container.getStartSteps(container.getStartOrder());
            }
        })));
    }

    private static Set<WlsContainer> gatherTargets(List<Delta> operations) {
        final Set<WlsContainer> wlsTargets = Sets.newHashSet();
        for (Delta operation : operations) {
            addTarget(wlsTargets, operation.getOperation(), operation.getDeployed());
            addTarget(wlsTargets, operation.getOperation(), operation.getPrevious());
        }
        return wlsTargets;
    }

    @SuppressWarnings("unchecked")
    private static void addTarget(Set<WlsContainer> wlsTargets, final Operation operation, Deployed<?, ?> deployed) {
        if (deployed == null)
            return;

        if (operation == Operation.NOOP)
            return;

        if (deployed instanceof Resource || deployed instanceof CopiedArtifact) {
            final boolean restartTarget = (Boolean) deployed.getProperty("restartTarget");
            ResourceTargetRestartPolicy restartPolicy = deployed.getProperty("targetRestartPolicy");
            if (restartTarget && restartPolicy == ResourceTargetRestartPolicy.STOP_START) {
                wlsTargets.add((WlsContainer) deployed.getContainer());
            }
        } else if (deployed instanceof ExtensibleDeployedArtifact) {
            ExtensibleDeployedArtifact<BaseDeployableArchiveArtifact> deployedArtifact = (ExtensibleDeployedArtifact<BaseDeployableArchiveArtifact>) deployed;
            final DeploymentStrategy deploymentStrategy = deployedArtifact.getRedeploymentStrategy();
            if (deploymentStrategy == DeploymentStrategy.STOP_START) {
                wlsTargets.add((WlsContainer) deployed.getContainer());
            }
        }
    }

}
