package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

@SuppressWarnings("serial")
public class WaitingStep implements Step {

    private final long waitTime;
    private int order;

    public WaitingStep(int order, long time) {
        if (time < 0)
            throw new RuntimeException("negative values invalid (" + time + ")");
        this.waitTime = time;
        this.order = order;
    }

    @Override
    public String getDescription() {
        return "Wait for " + this.waitTime + " second(s)";
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            Thread.sleep(waitTime * 1000);
        } catch (InterruptedException e) {
            ctx.logError("Interrupted!", e);
            Thread.currentThread().interrupt();
            return StepExitCode.FAIL;
        }

        ctx.logOutput("Done waiting");
        return StepExitCode.SUCCESS;
    }

    public long getWaitTime() {
        return waitTime;
    }

    @Override
    public int getOrder() {
        return order;
    }
}
