/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.utils.ModifiedDelta;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(virtual=true, description="Base class for all shared library deployeds")
@Placeholders
public class ExtensibleDeployedSharedLibrary<D extends DeployableArtifact>
extends ExtensibleDeployedArtifact<D> {
    private static final Logger logger = LoggerFactory.getLogger(ExtensibleDeployedSharedLibrary.class);
    @Property(defaultValue="wls.EarModule, wls.WarModule", hidden=true)
    private List<String> runtimeDependenciesTypes;

    @Modify
    public void handleRuntimeDependencies(DeploymentPlanningContext context, Delta delta) {
        try {
            List<ConfigurationItem> deployedArtifacts = this.searchRuntimeDeployeds(context);
            logger.debug("deployedArtifacts: " + deployedArtifacts);
            ExtensibleDeployedSharedLibrary deployed = this;
            Iterable runtimeDependenciesDeployedArtifacts = Iterables.filter(deployedArtifacts, (Predicate)new Predicate<ConfigurationItem>((ConfigurationItem)deployed){
                final /* synthetic */ ConfigurationItem val$deployed;
                {
                    this.val$deployed = configurationItem;
                }

                public boolean apply(ConfigurationItem input) {
                    List sharedLibraries = (List)input.getProperty("sharedLibraries");
                    return sharedLibraries.contains(this.val$deployed);
                }
            });
            for (ConfigurationItem configurationItem : runtimeDependenciesDeployedArtifacts) {
                logger.debug("%s(%s) Operation.MODIFY", (Object)configurationItem.getId(), (Object)configurationItem.getType());
                ExtensibleDeployedArtifact artifact = (ExtensibleDeployedArtifact)context.getRepository().read(configurationItem.getId());
                ModifiedDelta deltaArtifact = new ModifiedDelta((Deployed<?, ?>)artifact);
                artifact.stopApplicationForModifedArtifact(context, deltaArtifact);
                artifact.modifyArtifact(context, deltaArtifact);
                artifact.startApplication(context);
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private List<ConfigurationItem> searchRuntimeDeployeds(DeploymentPlanningContext context) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Repository repository = context.getRepository();
        for (String type : this.runtimeDependenciesTypes) {
            builder.addAll((Iterable)repository.search(Type.valueOf((String)type), ((WlsContainer)this.getContainer()).getId()));
        }
        return builder.build();
    }
}

