from time import sleep

connectAndEdit()

options = toWlsCommandArgs(deployed)
print 'raw install args:%s' %(options)

if deployed.file is None:
    print >>sys.stderr, "No file found to deploy, cannot proceed"
    discardAndExit()

deployableFile = deployed.file
# handling stageMode
if hasattr(deployed, 'stageMode'):
    stageMode = deployed.stageMode
    if stageMode == 'Stage':
        options['upload'] = 'true'
        options['stageMode'] = 'stage'
        print "stage mode"

    if stageMode == 'NoStage':
        options['stageMode'] = 'nostage'
        deployableFile = remoteDestinationFilename
        print "noStage mode: deployable file is ",deployableFile

# handling appVersion
del options['versioned']
if deployed.versioned == False:
    if options.has_key('versionIdentifier') == True:
        del options['versionIdentifier']
else:
    print "Version Identifier is ",options['versionIdentifier']

# handling side by side deployment
if deployed.retireTimeout == -1:
    if options.has_key('retireTimeout') == True:
        del options['retireTimeout']
else:
    print "Set retirement Timeout to", options['retireTimeout']


print "Deploying application ", deployed.name, " with the following options ", options
progress = deploy(deployed.name, deployableFile, deployed.container.name, **options)

if progress.isFailed():
    print >>sys.stderr, "Deployment failed:"
    progress.printStatus()
    discardAndExit()

if deployed.deploymentOrder <> 100:
    cd('/')
    cd(deployed.wlstPath)
    name = deployed.name
    if deployed.versioned == True:
        name = "%s#%s"%(deployed.name, deployed.versionIdentifier)
    cd(name)
    cmo.setDeploymentOrder(deployed.deploymentOrder)

saveAndExit()
