package com.xebialabs.deployit.plugin.wls.freemarker;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.wls.utils.Closeables;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

public class TemplateEvaluator {

    protected static final Logger logger = LoggerFactory.getLogger(TemplateEvaluator.class);

    public static void evaluateTemplate(OverthereFile renderTo, String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        OutputStream out = renderTo.getOutputStream();
        try {
            Template template = cfg.getTemplate(templatePath);
            template.process(vars, new OutputStreamWriter(out));
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        } catch (TemplateException e) {
            throw new RuntimeException(e);
        } finally {
            Closeables.closeQuietly(out);
        }
    }
}
