package com.xebialabs.deployit.plugin.wls.preplanprocessor;

import com.google.common.base.Strings;

import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.deployed.JmsDestination;
import com.xebialabs.deployit.plugin.wls.deployed.JmsResource;
import com.xebialabs.deployit.plugin.wls.resource.JmsResourceSpec;

import static com.xebialabs.deployit.plugin.api.deployment.specification.Operation.CREATE;
import static com.xebialabs.deployit.plugin.api.deployment.specification.Operation.DESTROY;
import static com.xebialabs.deployit.plugin.api.deployment.specification.Operation.MODIFY;

public class JmsResourceSubDeploymentSetter {

    @SuppressWarnings({"unchecked", "rawtypes"})
    @PrePlanProcessor
    public static Step setSubDeploymentName(DeltaSpecification spec) {

        for (Delta delta : spec.getDeltas()) {
            if (delta.getOperation() == CREATE || delta.getOperation() == MODIFY || delta.getOperation() == DESTROY) {
                final Deployed<?, ?> deployed = (delta.getOperation() == CREATE || delta.getOperation() == MODIFY) ? delta.getDeployed() : delta.getPrevious();
                if (JmsResource.class.isAssignableFrom(deployed.getClass())) {
                    JmsResource<JmsResourceSpec, JmsTarget> jmsResource = (JmsResource<JmsResourceSpec, JmsTarget>) deployed;
                    String subDeploymentName = jmsResource.getJmsModuleName() + "-subdeployment-for-" + jmsResource.getName();
                    setSubDeploymentIfNotSetPreviously(jmsResource, subDeploymentName);

                    if (JmsDestination.class.isAssignableFrom(deployed.getClass())) {
                        JmsDestination<JmsResourceSpec, JmsTarget, JmsDestination> jmsDestination = (JmsDestination<JmsResourceSpec, JmsTarget, JmsDestination>) deployed;
                        if (jmsDestination.getErrorDestination() != null) {
                            jmsDestination.getErrorDestination().setSubDeploymentName(jmsResource.getSubDeploymentName());
                        }
                    }
                }
            }
        }
        return null;
    }

    private static void setSubDeploymentIfNotSetPreviously(JmsResource<JmsResourceSpec, JmsTarget> jmsResource, String subDeploymentName) {
        if (Strings.isNullOrEmpty(jmsResource.getSubDeploymentName())) {
            jmsResource.setSubDeploymentName(subDeploymentName);
        }
    }
}
