#
connectAndEdit()

datasourcePath = '/JDBCSystemResources/%s/JDBCResource/%s' % (deployed.name, deployed.name)

if exists(datasourcePath):
    print 'Modifying data source %s for target %s' % (deployed.name, deployed.container.name)
    setOrOverride = overrideWithWarning
else:
    print 'Creating data source %s for target %s' % (deployed.name, deployed.container.name)
    cmo.createJDBCSystemResource(deployed.name)
    setOrOverride = set

cd(datasourcePath)
setOrOverride('Name', deployed.name)

cd('/JDBCSystemResources/%s' % (deployed.name))
newTargets = []
for t in get('Targets'):
    newTargets.append(t)
newTargets.append(ObjectName(deployed.container.objectName))
set('Targets', jarray.array(newTargets, ObjectName))

cd('%s/JDBCDriverParams/%s' % (datasourcePath, deployed.name))
setOrOverride("Url", deployed.url)
setOrOverride("DriverName", deployed.driverName)
setOrOverride('PasswordEncrypted', encrypt(deployed.password, deployed.container.domain.domainHome))

cd('%s/JDBCDriverParams/%s/Properties/%s' % (datasourcePath, deployed.name, deployed.name))
if not exists('Properties/user'):
    cmo.createProperty('user')
cd('Properties/user')
setOrOverride("Value", deployed.username)

cd('%s/JDBCDataSourceParams/%s' % (datasourcePath, deployed.name))
setOrOverride('JNDINames', jarray.array(deployed.jndiNames.split(','), String))

#set extra values in any at this level
propsToSet = deployed.getExposedProperties()
for key, value in propsToSet.items():
    if value is not None and isinstance(value, DictionaryObject) == False:
        print 'setting %s with value %s' % (key, value)
        set(key, value)

# create all the nested objects like ConnectionPool, JDBCParams etc
nestedObjects = findAllNestedObjects(deployed)
if len(nestedObjects) != 0:
    print "now setting properties %s" %(nestedObjects)
    setNestedPropertiesRecursively(deployed.name, datasourcePath, nestedObjects, set)


# Set other properties on the JBDCDriverParams
if hasattr(deployed, 'properties') and deployed.properties is not None:
    for propKey, propVal in deployed.properties.items():
        cd('%s/JDBCDriverParams/%s/Properties/%s' % (datasourcePath, deployed.name, deployed.name))
        if not exists('Properties/%s' % (propKey)):
            cmo.createProperty(propKey)
        cd('Properties/%s' % (propKey))
        setOrOverride("Value", propVal)

saveAndExit()
