package com.xebialabs.deployit.plugin.wls.contributor;

import java.util.HashSet;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.wls.step.DeleteArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.UploadArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WaitingStep;

import static com.xebialabs.deployit.plugin.wls.CustomWlsOrders.RETIREMENT_TIMEOUT;

public class ArtifactDeploymentContributor {

    private static final String UPLOAD_ARTIFACT_STEPS = "uploadArtifactSteps";
    private static final String WAITING_STEP_INTERVAL = "waitingStepInterval";
    private static final String DELETE_ARTIFACT_STEPS = "deleteArtifactStep";

    @Contributor
    public static void contributeArtifactUploadStepForNoStage(@SuppressWarnings("unused") Deltas deltas, DeploymentPlanningContext ctx) {
        for (UploadArtifactStep uploadStep : getUploadArtifactSteps(ctx)) {
            ctx.addStep(uploadStep);
        }
    }

    @Contributor
    public static void contributeArtifactDeleteStepForNoStage(@SuppressWarnings("unused") Deltas deltas, DeploymentPlanningContext ctx) {
        for (DeleteArtifactStep deleteArtifactStep : getDeleteArtifactSteps(ctx)) {
            ctx.addStep(deleteArtifactStep);
        }
    }

    @Contributor
    public static void contributeWaitStepForSideBySideDeploymentStrategy(@SuppressWarnings("unused") Deltas deltas, DeploymentPlanningContext ctx) {
        if (ctx.getAttribute(WAITING_STEP_INTERVAL) != null) {
            ctx.addStep(new WaitingStep(RETIREMENT_TIMEOUT, (Long) ctx.getAttribute(WAITING_STEP_INTERVAL)));
        }
    }

    public static void addUploadArtifactStep(DeploymentPlanningContext ctx, UploadArtifactStep step) {
        getUploadArtifactSteps(ctx).add(step);
    }

    public static void addDeleteArtifactStep(DeploymentPlanningContext ctx, DeleteArtifactStep step) {
        getDeleteArtifactSteps(ctx).add(step);
    }

    public static void setWaitStepInterval(DeploymentPlanningContext ctx, long newWaitTime) {
        if (ctx.getAttribute(WAITING_STEP_INTERVAL) != null) {
            long waitTimeInSec = (Long) ctx.getAttribute(WAITING_STEP_INTERVAL);
            if (newWaitTime > waitTimeInSec) {
                ctx.setAttribute(WAITING_STEP_INTERVAL, newWaitTime);
            }
        }else {
            ctx.setAttribute(WAITING_STEP_INTERVAL, newWaitTime);
        }
    }

    @SuppressWarnings("unchecked")
    private static Set<UploadArtifactStep> getUploadArtifactSteps(DeploymentPlanningContext ctx) {
        Set<UploadArtifactStep> steps = (Set<UploadArtifactStep>) ctx.getAttribute(UPLOAD_ARTIFACT_STEPS);
        if (steps == null) {
            steps = new HashSet<UploadArtifactStep>();
            ctx.setAttribute(UPLOAD_ARTIFACT_STEPS, steps);
        }
        return steps;
    }

    @SuppressWarnings("unchecked")
    private static Set<DeleteArtifactStep> getDeleteArtifactSteps(DeploymentPlanningContext ctx) {
        Set<DeleteArtifactStep> steps = (Set<DeleteArtifactStep>) ctx.getAttribute(DELETE_ARTIFACT_STEPS);
        if (steps == null) {
            steps = new HashSet<DeleteArtifactStep>();
            ctx.setAttribute(DELETE_ARTIFACT_STEPS, steps);
        }
        return steps;
    }

}
