package com.xebialabs.deployit.plugin.wls.freemarker;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.io.StringReader;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.wls.utils.Closeables;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;

import freemarker.template.Template;
import freemarker.template.TemplateException;


public class TemplateEvaluator {

    protected static final Logger logger = LoggerFactory.getLogger(TemplateEvaluator.class);

    public static void evaluateTemplate(OverthereFile renderTo, final String templatePath, Map<String, Object> vars) {
        OutputStream out = renderTo.getOutputStream();
            processTemplate(new OutputStreamWriter(out), vars, new TemplateCreator() {
                @Override
                public Template getTemplate() throws IOException {
                    return ConfigurationHolder.getConfiguration().getTemplate(templatePath);
                }
            });
    }

    public static String evaluateExpression(final String expression, Map<String, Object> vars) {
        StringWriter out = new StringWriter();
        processTemplate(out, vars, new TemplateCreator() {
            @Override
            public Template getTemplate() throws IOException {
                return new Template("TempTemplate", new StringReader(expression), ConfigurationHolder.getConfiguration());
            }
        });
        return out.toString();
    }

    private interface TemplateCreator {
        Template getTemplate() throws IOException;
    }

    private static void processTemplate(Writer outputWriter, Map<String, Object> vars, TemplateCreator creator) {
        try {
            Template template = creator.getTemplate();
            template.process(vars, outputWriter);
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        } catch (TemplateException e) {
            throw new RuntimeException(e);
        } finally {
            Closeables.closeQuietly(outputWriter);
        }
    }
}
