#

inspected('adminServerName', get('AdminServerName'))
inspected('domainHome', get('RootDirectory'))

clusters = ls('/Clusters', returnMap = 'true')
if not clusters.isEmpty():
    for c in clusters:
        discovered(container.id + '/' + c, 'wls.Cluster')

servers = ls('/Servers', returnMap = 'true')
if not servers.isEmpty():
    for s in servers:
        discovered(container.id + '/' + s, 'wls.Server')

jmsServers = ls('/JMSServers', returnMap = 'true')
if not jmsServers.isEmpty():
    for j in jmsServers:
        targets = ls('/JMSServers/' + j + '/Targets', returnMap = 'true')
        if len(targets) == 1:
            if targets[0] in servers:
                discovered(container.id + '/' + targets[0] + '/' + j, 'wls.JmsServer')
            else:
                print "Ignoring JMSServer", j, "associated with non-server target", targets[0]
        else:
            print >> sys.stderr, "JMSServer", j, "does not have exactly one target"
