package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.wls.container.Server;

import java.util.HashMap;
import java.util.Map;

import static com.google.common.base.Preconditions.checkState;

@SuppressWarnings("serial")
public class StartWlsServerWithScriptStep extends ScriptExecutionStep {

    public StartWlsServerWithScriptStep(int order, Server server) {
        super(order, (String) server.getProperty("startScript"), server.getHost(), buildPythonVars(server), getDescription(server));
        checkState(!Strings.nullToEmpty(server.getStartCommand()).trim().isEmpty(), "startCommand is blank for " + server);
        checkState(server.getHost() != null, "Can only start a wls.Server with a script when it its host property has been set");
    }

    private static String getDescription(Server server) {
        return String.format("Start Weblogic server %s using a script", server);
    }

    private static Map<String, Object> buildPythonVars(Server server) {
        Map<String, Object> vars = new HashMap<String, Object>();
        vars.put("container", server);
        return vars;
    }
}
