package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("serial")
public class StopWlsTargetStep extends PythonDeploymentStep {

    public StopWlsTargetStep(int order, WlsContainer target) {
        super(order, target.getManagingContainer(), "wls/container/stop-target.py", buildPythonVars(target), "Stop " + target);
    }

    private static Map<String, Object> buildPythonVars(WlsContainer target) {
        Map<String, Object> vars = new HashMap<String, Object>();
        vars.put("target", target);
        vars.put("type", (target instanceof Server ? "Server" : "Cluster"));
        return vars;
    }
}
