def discoverQueues():

    def getQueueId(path):
        subDeploymentName=getAttributesAsMap(path)['SubDeploymentName']
        subDeployment = find(type="SubDeployment",name="%s" % (subDeploymentName))[0]
        jmsTarget=getChildrenAsMap("%s/Targets" % subDeployment)[0]
        wlsTarget=getChildrenAsMap("/JMSServers/%s/Targets" % jmsTarget)[0]
        return "%s/%s/%s/%s" % (container.id, wlsTarget, jmsTarget, getAttributesAsMap(path)['Name'])

    def inspectQueue(path):
        queueId = getQueueId(path)
        discovered(queueId, prototype.type)
        attrs=getAttributesAsMap(path)
        inspectedProperty(queueId, "jndiName", attrs["JNDIName"])
        inspectedProperty(queueId, "jmsModuleName", path.split('/')[2])
        inspectedProperty(queueId, "subDeploymentName", attrs["SubDeploymentName"])
        inspectedMapOfProperties(queueId, attrs)
        for attr in ls(path,returnMap='true', returnType='c'):
            if exist("%s/%s" % (path,attr)):
                inspectedMapOfProperties(queueId,getAttributesAsMap("%s/%s/%s" %(path,attr,attrs['Name']),prefix="%s_"%attr))
        inspectedItem(queueId)
        return queueId

    [inspectQueue(o) for o in find(type="Queue")]
