/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.container;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.wls.container.Cluster;
import com.xebialabs.deployit.plugin.wls.container.Domain;
import com.xebialabs.deployit.plugin.wls.container.JmsTarget;
import com.xebialabs.deployit.plugin.wls.container.StopWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsTargetStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsTargetStep;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="WebLogic Server that runs in its own Java Virtual Machine (JVM) and has its own configuration")
public class Server
extends BaseContainer
implements WlsContainer,
JmsTarget {
    protected final Map<String, Object> context = Maps.newHashMap();
    private static final String START_CONTROL_TASK = "start";
    private static final String STOP_CONTROL_TASK = "stop";
    @Property(required=true, description="Port for the server runs on")
    private int port;
    @Property(required=true, asContainment=true, description="WebLogic domain to which this server belongs. 'asContainment'=true, means a Server is 'contained' under a Domain", category="Topology")
    private Domain domain;
    @Property(required=false, description="Host on which this server is running, needed to perform no-stage deployments and to start the server via a script")
    private Host host;
    @Property(required=false, label="Managed server start command", description="Command that should be executed to start the managed server.")
    private String startCommand;
    @Property(required=false, label="Managed server stop command", description="Command that should be executed to stop the managed server.")
    private String stopCommand;
    @Property(required=false, description="Environment variables for server", label="Environment Variables")
    private Map<String, String> envVars = Maps.newHashMap();
    @Property(required=true, defaultValue="80", hidden=true)
    private int startOrder;
    @Property(required=true, defaultValue="20", hidden=true)
    private int stopOrder;
    @Property(required=true, hidden=true, defaultValue="1", description="The time to wait in seconds for a container start action.")
    private int startWaitTime;

    public Server() {
        this.context.put("container", this);
    }

    @Override
    public String getObjectName() {
        return "com.bea:Name=" + this.getName() + ",Type=Server";
    }

    @Inspect
    public void inspect(InspectionContext ctx) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("container", this);
        ctx.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, this.getManagingContainer(), "wls/container/inspect-server.py", (Map)pythonVars, "Inspect " + this));
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public Set<Host> getHosts() {
        Preconditions.checkState((this.host != null ? 1 : 0) != 0, (Object)"Can only perform no-stage deployments to server that has their host property set");
        return Collections.singleton(this.host);
    }

    public Cluster getClusterIfAny() {
        Set<Cluster> clusters = this.domain.getClusters();
        for (Cluster eachCluster : clusters) {
            if (!eachCluster.getServers().contains(this)) continue;
            return eachCluster;
        }
        return null;
    }

    @Override
    public Set<Server> getServers() {
        return Collections.singleton(this);
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public String getStopCommand() {
        return this.stopCommand;
    }

    public void setStopCommand(String stopCommand) {
        this.stopCommand = stopCommand;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.domain;
    }

    @Override
    public int getStartOrder() {
        return this.startOrder;
    }

    @Override
    public int getStopOrder() {
        return this.stopOrder;
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        if (name.equals(STOP_CONTROL_TASK)) {
            return this.getStopSteps(1);
        }
        if (name.equals(START_CONTROL_TASK)) {
            return this.getStartSteps(1);
        }
        return ControlTaskDelegate.dispatch((String)name, args, (ConfigurationItem)this, (Container)this);
    }

    @Override
    public List<Step> getStartSteps(int order) {
        switch (this.getDomain().getStartMode()) {
            case NodeManager: {
                return ImmutableList.of((Object)((Object)new StartWlsTargetStep(order, this)));
            }
            case Script: {
                return ImmutableList.of((Object)((Object)new StartWlsServerWithScriptStep(order, this)));
            }
        }
        throw new RuntimeException("Unsupported StopStartMode" + (Object)((Object)this.getDomain().getStartMode()));
    }

    @Override
    public List<Step> getStopSteps(int order) {
        switch (this.getDomain().getStartMode()) {
            case NodeManager: {
                return ImmutableList.of((Object)((Object)new StopWlsTargetStep(order, this)));
            }
            case Script: {
                return ImmutableList.of((Object)((Object)new StopWlsServerWithScriptStep(order, this)));
            }
        }
        throw new RuntimeException("Unsupported StopStartMode" + (Object)((Object)this.getDomain().getStartMode()));
    }
}

