/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.util;

import com.crossingchannels.portal.websphere.util.UnexpectedXmlElementException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class XmlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtil.class);

    public static <T> T loadDom(InputStream inputStream, Package domPackage, Class<T> expectedDomType, XMLFilter xmlFilter) throws JAXBException, UnexpectedXmlElementException {
        Object domObj;
        XMLReader reader;
        Validate.notNull((Object)inputStream);
        Validate.notNull((Object)domPackage);
        LOGGER.trace("Start loading XML from stream. DOM objects are located inside package [{}]. Expected DOM object to return is [{}]", (Object)domPackage, expectedDomType);
        JAXBContext jc = JAXBContext.newInstance((String)domPackage.getName());
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        InputSource inputSource = new InputSource(inputStream);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            reader = factory.newSAXParser().getXMLReader();
        }
        catch (SAXException e) {
            throw new JAXBException("Unable to initialize SAX parser", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new JAXBException("Unable to initialize SAX parser due to parser configuration error", (Throwable)e);
        }
        reader.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
        if (xmlFilter != null) {
            xmlFilter.setParent(reader);
            domObj = unmarshaller.unmarshal((Source)new SAXSource(xmlFilter, inputSource));
        } else {
            domObj = unmarshaller.unmarshal((Source)new SAXSource(reader, inputSource));
        }
        if (domObj instanceof JAXBElement) {
            domObj = ((JAXBElement)domObj).getValue();
        }
        if (expectedDomType != null && !expectedDomType.isInstance(domObj)) {
            throw new UnexpectedXmlElementException(expectedDomType, domObj);
        }
        return (T)domObj;
    }

    public static String getValue(String expression, InputStream stream) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        return xPath.evaluate(expression, new InputSource(stream));
    }

    private XmlUtil() {
    }
}

