package com.crossingchannels.portal.websphere.ci.base.step;

import java.text.MessageFormat;

import org.apache.commons.lang.Validate;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

/**
 * @author fwiegerinck
 */
@SuppressWarnings("serial")
public abstract class AbstractDeploymentStep implements Step {

    /**
     * Store reference to description.
     */
    private final String description;

    /**
     * Store order for this step.
     */
    private final int order;

    /**
     * Initialize new deployment step with supplied elements.
     * 
     * @param description
     *            Description for this step.
     * @param order
     *            Order of this step.
     */
    protected AbstractDeploymentStep(final String description, final int order) {

        // Preconditions
        Validate.notNull(description);
        Validate.isTrue((order > 0) && (order < 101));

        // Store value
        this.description = description;
        this.order = order;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getDescription() {
        return this.description;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int getOrder() {
        return this.order;
    }

    /**
     * A property-exists safe way to get a property.
     * 
     * @param deployedCi
     *            CI containing the property.
     * @param propertyName
     *            The property to retrieve.
     * @param requiredType
     *            The required type of property.
     * @return The requested value.
     */
    protected <T> T getProperty(final Deployed<?, ?> deployedCi, final String propertyName, final Class<T> requiredType) {

        Validate.notNull(deployedCi);
        Validate.notEmpty(propertyName);
        Validate.notNull(requiredType);

        // Attempt to retrieve property descriptor
        final PropertyDescriptor pd = deployedCi.getType().getDescriptor().getPropertyDescriptor(propertyName);

        // Ensure property is valid
        if (pd == null) {
            throw new IllegalArgumentException(MessageFormat.format("Missing property \"{0}\" for CI {1}", propertyName, deployedCi.getId()));
        }

        // Get value
        final Object value = deployedCi.getProperty(propertyName);

        // Return type
        return requiredType.cast(value);

    }

}
