package com.crossingchannels.portal.websphere.ci.portlet.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.Validate;

import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecurityLevel;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubject;
import com.crossingchannels.portal.websphere.ci.portlet.types.LocalizedPortletInfo;
import com.crossingchannels.portal.websphere.model.BaseModelElement;

import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;

/**
 * A base model used for {@link ClonedPortlet} and {@link Portlet}.
 * 
 * @author fwiegerinck
 */
@SuppressWarnings("serial")
public class BasePortletModel extends BaseModelElement {
	
	private final BasePortlet<?, ?> ci;
	
	/**
	 * @param name
	 * @param portletCi The portlet CI
	 */
	BasePortletModel(final BasePortlet<?,?> portletCi) {
	    super();
	    
	    // Preconditions
	    Validate.notNull(portletCi);
	    
	    // Store values
	    this.ci = portletCi;
	}
	
	public BasePortlet<?, ?> getCi() {
		return ci;
	}
	
	public String getUniqueName() {
		return this.ci.getUniqueName();
	}
	
	public Map<String, String> getPreferences() {
		return this.ci.getPreferences();
	}
	
	public String getDefaultLocale() {
		return this.ci.getDefaultLocale();
	}
	
	public Set<LocalizedPortletInfo> getLocalizedPortletInfo () {
		return this.ci.getLocalizedPortletInfo();
	}
	
	public Map<String, Set<PortalSecuritySubject>> getAclMapping() {
		final Map<PortalSecurityLevel, Set<PortalSecuritySubject>> mapping = this.ci.getMergedAclMapping();
		
		// Remove NONE-mapping
		if ( mapping.containsKey(PortalSecurityLevel.NONE) ) {
			mapping.remove(PortalSecurityLevel.NONE);
		}
		
		// Change to String-based Map to satisfy FreeMarker
		final Map<String, Set<PortalSecuritySubject>> convertedMapping = new HashMap<String, Set<PortalSecuritySubject>>();
		for(Map.Entry<PortalSecurityLevel, Set<PortalSecuritySubject>> entry : mapping.entrySet()) {
			convertedMapping.put(entry.getKey().getXmlAccessName(), entry.getValue());
		}
		
		return convertedMapping;
	}

}
