package com.crossingchannels.portal.websphere.ci.portlet.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.crossingchannels.portal.websphere.model.BaseModelElement;

/**
 * @author FWiegerinck
 * 
 */
@SuppressWarnings("serial")
public class WebModule extends BaseModelElement {

    private final String locationOnDisk;

    private final String contextRoot;

    private final String displayName;

    private final List<PortletApplication> portletApplications;

	private final String uniqueIdentifier;

    /**
     * @param locationOnDisk
     * @param contextRoot
     * @param displayName
     * @param portletApplications
     */
    WebModule(final String locationOnDisk, final String contextRoot, final String displayName, final String uniqueIdentifier, final List<PortletApplication> portletApplications) {
        super();
        this.locationOnDisk = locationOnDisk;
        this.contextRoot = contextRoot;
        this.displayName = displayName;
        this.uniqueIdentifier = uniqueIdentifier;
        this.portletApplications = Collections.unmodifiableList(new ArrayList<PortletApplication>(portletApplications));
    }

    /**
     * @return the locationOnDisk
     */
    public String getLocationOnDisk() {
        return this.locationOnDisk;
    }

    /**
     * @return the contextRoot
     */
    public String getContextRoot() {
        return this.contextRoot;
    }

    /**
     * @return the displayName
     */
    public String getDisplayName() {
        return this.displayName;
    }
    
    public String getUniqueIdentifier() {
		return uniqueIdentifier;
	}

	/**
     * @return the portletApplications
     */
    public List<PortletApplication> getPortletApplications() {
        return this.portletApplications;
    }

}
