package com.crossingchannels.portal.websphere.ci.portlet.model;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;

import org.apache.commons.lang.Validate;

import com.crossingchannels.portal.websphere.model.AbstractModelElementFactory;
import com.crossingchannels.portal.websphere.specification.jee5.IllegalDescriptorFoundException;
import com.crossingchannels.portal.websphere.specification.jee5.WebArchive;

import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;

/**
 * Builder to create different types of model elements
 * 
 * @author FWiegerinck
 */
public class WebModuleBuilder extends AbstractModelElementFactory<WebModule> {

    public static WebModuleBuilder create(final String locationOnDisk, final String contextRoot) {
        return new WebModuleBuilder(locationOnDisk, contextRoot);
    }

    private final String locationOnDisk;
    private final String contextRoot;
    private String displayName;
    private String uniqueIdentifier;
    private PortletApplication portletApplication;

    /**
     * Hide constructor for utility/builder class
     */
    private WebModuleBuilder(final String locationOnDisk, final String contextRoot) {
        super();

        // Store information
        this.locationOnDisk = locationOnDisk;
        this.contextRoot = contextRoot;
    }

    public WebModuleBuilder use(final WebArchive webArchive, final Set<BasePortlet<?,?>> portlets, final boolean autoScanForPortlets) throws IllegalDescriptorFoundException, IOException {
        this.displayName = webArchive.getDescriptor().getDisplayName();
        if ( this.displayName == null ) {
        	final String webArchiveName = webArchive.getArchiveName();
        	this.displayName = webArchiveName.substring(0, webArchiveName.lastIndexOf("."));
        }
        this.uniqueIdentifier = webArchive.getDescriptor().getUniqueIdentifier();
        this.portletApplication = PortletApplicationBuilder.create(webArchive.getPortletDescriptor()).withPortlets(portlets, autoScanForPortlets).toModel();

        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WebModule toModel() {
        Validate.notNull(this.contextRoot);
        Validate.notNull(this.displayName);

        // Do generate items
        return new WebModule(this.locationOnDisk, this.contextRoot, this.displayName, this.uniqueIdentifier, Collections.singletonList(this.portletApplication));
    }
}
