package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container;

import java.text.MessageFormat;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;

/**
 * CI container to represent a virtual portal. A virtual portal is created on top of an underlying {@link WpRuntimeContainer}.
 * 
 * @author FWiegerinck
 */
@Metadata(root = ConfigurationItemRoot.NESTED, description = "A virtual portal that runs on top of WebSphere Portal server.", virtual = false)
@SuppressWarnings("serial")
public class VirtualPortal extends BaseContainer implements WpContainer {

    /**
     * Reference to the underlying {@link WpRuntimeContainer}.
     */
    @Property(label = "Runtime container", description = "Containing Portal Server", required = true, asContainment = true)
    private WpRuntimeContainer container;

    /**
     * Name of the virtual portal.
     */
    @Property(label = "Virtual Portal Name", description = "Name of virtual portal", required = true)
    private String wpVirtualPortalName;

    /**
     * @return the wpRuntime
     */
    public WpRuntimeContainer getWpRuntime() {
        return this.container;
    }

    /**
     * @return the wpVirtualPortalName
     */
    public String getWpVirtualPortalName() {
        return this.wpVirtualPortalName;
    }

    /**
     * @param wpRuntime
     *            the wpRuntime to set
     */
    public void setWpRuntime(final WpRuntimeContainer wpRuntime) {
        this.container = wpRuntime;
    }

    /**
     * @param wpVirtualPortalName
     *            the wpVirtualPortalName to set
     */
    public void setWpVirtualPortalName(final String wpVirtualPortalName) {
        this.wpVirtualPortalName = wpVirtualPortalName;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getWpConfigUrl() {
        return MessageFormat.format("{0}/{1}", this.container.getWpConfigUrl(), this.wpVirtualPortalName);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WpRuntimeContainer getRuntimeContainer() {
        return this.container;
    }

}
