package ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecurityLevel;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubject;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubjectType;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot;

/**
 * Define concrete ACL mapping used to map user and groups to a certain ACL mapping.
 * 
 * @author fwiegerinck
 */
@SuppressWarnings("serial")
@Metadata(description = "Define ACL mapping for users and groups", root=ConfigurationItemRoot.NESTED)
public class BaseAclMapping extends AbstractAclMapping {

	@Property(label = "Security level", description="Set the security level for this mapping.", required=true)
	private PortalSecurityLevel securityLevel;
	
	@Property(label = "Users", description="Define set of users for this mapping", required=false)
	private Set<String> users;
	
	@Property(label = "Groups", description="Define set of groups for this mapping", required=false)
	private Set<String> groups;
	
	public PortalSecurityLevel getSecurityLevel() {
		return securityLevel;
	}

	public void setSecurityLevel(PortalSecurityLevel securityLevel) {
		this.securityLevel = securityLevel;
	}

	public Set<String> getUsers() {
		return users;
	}

	public void setUsers(final Set<String> users) {
		if ( users != null ) {
			this.users = users;
		} else {
			this.users = new HashSet<String>();
		}
	}

	public Set<String> getGroups() {
		return groups;
	}

	public void setGroups(final Set<String> groups) {
		if ( groups != null ) {
			this.groups = groups;
		} else {
			this.groups = new HashSet<String>();
		}
	}

	@Override
	public Map<PortalSecurityLevel, Set<PortalSecuritySubject>> getMapping() {
		
		final Set<PortalSecuritySubject> subjects = new HashSet<PortalSecuritySubject>(this.users.size() + this.groups.size());
		for( final String user : this.users ) {
			subjects.add(new PortalSecuritySubject(user, PortalSecuritySubjectType.USER));
		}
		for( final String group : this.groups ) {
			subjects.add(new PortalSecuritySubject(group, PortalSecuritySubjectType.GROUP));
		}
		
		final Map<PortalSecurityLevel, Set<PortalSecuritySubject>> mapping = new HashMap<PortalSecurityLevel, Set<PortalSecuritySubject>>();
		mapping.put(this.securityLevel, subjects);
		
		return mapping;
	}

}
