/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.ci.base.step;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.text.MessageFormat;
import org.apache.commons.lang.Validate;

public abstract class AbstractDeploymentStep
implements Step {
    private final String description;
    private final int order;

    protected AbstractDeploymentStep(String description, int order) {
        Validate.notNull((Object)description);
        Validate.isTrue((order > 0 && order < 101 ? 1 : 0) != 0);
        this.description = description;
        this.order = order;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOrder() {
        return this.order;
    }

    protected <T> T getProperty(Deployed<?, ?> deployedCi, String propertyName, Class<T> requiredType) {
        Validate.notNull(deployedCi);
        Validate.notEmpty((String)propertyName);
        Validate.notNull(requiredType);
        PropertyDescriptor pd = deployedCi.getType().getDescriptor().getPropertyDescriptor(propertyName);
        if (pd == null) {
            throw new IllegalArgumentException(MessageFormat.format("Missing property \"{0}\" for CI {1}", propertyName, deployedCi.getId()));
        }
        Object value = deployedCi.getProperty(propertyName);
        return requiredType.cast(value);
    }
}

