/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.ci.policy.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFileArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.overthere.OverthereFile;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpRuntimeContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step.ExecuteXmlAccessConfigurationItemStep;

public class PolicyDeploymentStep
extends ExecuteXmlAccessConfigurationItemStep {
    private static final String CONTEXTNAME_LOCATION_ON_REMOTE_FS = "locationOfPolicyOnRemoteFs";
    private final BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer> deployedCi;

    public PolicyDeploymentStep(String script, BaseDeployedArtifact<BaseDeployableFileArtifact, WpRuntimeContainer> deployedCi, int order) {
        super(script, (Deployed<? extends Deployable, ? extends WpContainer>)deployedCi, order);
        this.deployedCi = deployedCi;
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) {
        WpRuntimeContainer runtimeContainer = (WpRuntimeContainer)this.deployedCi.getContainer();
        OverthereFile policyFile = runtimeContainer.getHost().getConnection().getTempFile("registerPolicy", ".xml");
        ctx.logOutput("Copy policy file to target host");
        this.deployedCi.getFile().copyTo(policyFile);
        String path = policyFile.getPath().replace('\\', '/');
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.addToStepContext(CONTEXTNAME_LOCATION_ON_REMOTE_FS, path);
        return super.execute(ctx);
    }
}

