package com.crossingchannels.portal.websphere.ci.generic.types;

/**
 * Define security levels support by WebSphere Portal.
 * See also: http://publib.boulder.ibm.com/infocenter/wpdoc/v6r0/index.jsp?topic=/com.ibm.wp.ent.doc/wpf/sec_roles.html
 * 
 * @author fwiegerinck
 */
public enum PortalSecurityLevel {

	/**
	 * Cannot interact with resource.
	 */
	NONE(null),
	
	/**
	 * Viewing portal content. For example, viewing a specific page.
	 */
	USER("user"),
	
	/**
	 * Viewing portal content, customizing portlets and pages, and creating new private pages.
	 */
	PRIVILEGED_USER("privileged user"),
	
	/**
	 * Viewing portal content and creating new resources. The Contributor role type does not include the 
	 * permission to edit resources. It only allows you to create new resources. For example, a user is 
	 * granted the Contributor role on the Template Category Teamspaces. The user will not be able to modify
	 * the category itself but can create new templates in this category.
	 */
	CONTRIBUTOR("contributor"),
	
	/**
	 * Creating new resources and configuring existing resources that are used by multiple users.
	 */
	EDITOR("editor"),
	
	/**
	 * Creating new resources and configuring and deleting existing resources that are used by multiple users.
	 */
	MANAGER("manager"),
	
	/**
	 *  Assigning the Delegator role to principals (users and groups) allows roles to be granted to them.
	 *  Having the Delegator role on other resources, such as specific portlets, is not useful. The set of 
	 *  roles that can be granted to those principals is defined through the Security Administrator and
	 *  Administrator role types. For example a user has a Delegator role on the SalesTeam user group but
	 *  no Delegator role on the Managers user group, so this user can grant roles only to the SalesTeam or
	 *  individual members of the SalesTeam user group but not to the Managers user group. Having the
	 *  Delegator role on a resource does not give direct access to the resource. The purpose of the Delegator
	 *  role type is to allow the granting of roles to users or groups, so assigning Delegator role on resources
	 *  or resource types that are not users or user groups will not grant those users additional privileges.
	 */
	DELEGATOR("delegator"),
	
	/**
	 * Creating and deleting role assignments on resources. Being assigned Security Administrator role at some
	 * resource means that the user shall be allowed to act as a delegated administrator for that resource, in
	 * other words the Security Administrator on a resource is allowed to delegate a subset of their privileges
	 * on the resource to other people according to the Delegated Administration Policy. For example, a user who
	 * is assigned Security Administrator and Editor role on a resource can assign this Editor role to other people
	 * provided he has Delegator role on those people. Having the Security Administrator role on a resource alone
	 * does not give view or edit access to the resource.
	 */
	SECURITY_ADMINISTRATOR("security administrator"),
	
	/**
	 * Unrestricted access on resources. This includes creating, configuring, and deleting resources. Administrators
	 * can also change the access control settings on resource; in other words grant other people access to those
	 * resources.
	 */
	ADMINISTRATOR("administrator");
	
	/**
	 * Define name used by xmlAccess.
	 */
	private final String xmlAccessName;
	
	/**
	 * Initialize new security level.
	 * @param xmlAccessName The XML Access representation assigned to this security level.
	 */
	PortalSecurityLevel(final String xmlAccessName) {
		this.xmlAccessName = xmlAccessName;
	}
	
	/**
	 * Get the XML Access representation/name of the security level.
	 * 
	 * @return The XML Access representations.
	 */
	public String getXmlAccessName() {
		return xmlAccessName;
	}
	
}
