package com.crossingchannels.portal.websphere.ci.portlet.step;

import java.util.Map;

import com.crossingchannels.portal.websphere.ci.base.util.CastHelper;
import com.crossingchannels.portal.websphere.ci.portlet.model.PortletArchive;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;

import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step.ExecuteXmlAccessConfigurationItemStep;


/**
 * Abstract portlet application containing generic logic to process portlet application installation.
 * 
 * @author FWiegerinck
 */
@SuppressWarnings("serial")
public abstract class AbstractPortletApplicationActionStep extends ExecuteXmlAccessConfigurationItemStep {

    /**
     * Define name of the CI-property containing the register XML Access Script.
     */
    public static final String PROPERTY_REGISTER_SCRIPT = "createXmlAccessScript";

    /**
     * Define name of the CI-property containing the unregister XML Access Script.
     */
    public static final String PROPERTY_UNREGISTER_SCRIPT = "destroyXmlAccessScript";

    /**
     * Define name of the CI-property containing the order to run the register script.
     */
    public static final String PROPERTY_REGISTER_ORDER = "createXmlAccessOrder";

    /**
     * Define name of the CI-property containing the order to run the unregister script.
     */
    public static final String PROPERTY_UNREGISTER_ORDER = "destroyXmlAccessOrder";	
	
    private final ExtensibleDeployedArtifact artifactToInstall;

    /**
     * @param script
     * @param artifactToInstall
     * @param order
     */
    public AbstractPortletApplicationActionStep(final String script, final ExtensibleDeployedArtifact artifactToInstall, final int order) {
        super(script, CastHelper.<Deployed<? extends Deployable, ? extends WpContainer>>cast(artifactToInstall), order);

        this.artifactToInstall = artifactToInstall;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void updateExecutionContext(final Map<String, Object> context) {
        // Retrieve additional information from CI
        context.put("model", this.buildModel(this.artifactToInstall));
    }

    protected abstract PortletArchive buildModel(final ExtensibleDeployedArtifact artifactToInstall);

}
