package com.crossingchannels.portal.websphere.util;

/**
 * Exception thrown if any unexpected root XML element has been found.
 * 
 * @author FWiegerinck
 */
@SuppressWarnings("serial")
public class UnexpectedXmlElementException extends Exception {

    /**
     * Initialize new exception with the expected and actual element type.
     */
    public UnexpectedXmlElementException(final Class<?> expectedDomElement, final Object actualObject) {
        super(String.format("Unexpected root XML element found. Expected [%s], found [%s]", expectedDomElement, actualObject));
    }

}
