package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container;

import com.xebialabs.deployit.plugin.api.udm.Container;


/**
 * Tagging interface for a container (both runtime and virtual) to contain portal resources.
 * 
 * @author fwiegerinck
 */
public interface WpContainer extends Container {

    /**
     * Get the configuration URL for this container.
     * 
     * @return The full URL used to configure the container.
     */
    String getWpConfigUrl();

    /**
     * Get the reference to the underlying runtime container.
     * 
     * @return Instance of the runtime container. In case of a runtime container instance, the same instance can be returned.
     */
    WpRuntimeContainer getRuntimeContainer();
}
