package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.deployed;

import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;

import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.deployable.DeployableXmlAccessConfigurationItem;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step.ExecuteXmlAccessConfigurationItemStep;

/**
 * Deployed CI identifying a deployed XML access script resource.
 * 
 * @author fwiegerinck
 */
@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Resource deployed using XML Access")
public class DeployedXmlAccessConfigurationItem<D extends DeployableXmlAccessConfigurationItem> extends BaseDeployed<D, WpContainer> {

    @Property(hidden = true, defaultValue = "")
    private String createScript;

    @Property(hidden = true, defaultValue = "", required = false)
    private String destroyScript;

    @Property(hidden = true, defaultValue = "", required = false)
    private String modifyScript;

    @Property(hidden = true, defaultValue = "50")
    private int createOrder;

    @Property(hidden = true, defaultValue = "50", required = false)
    private int destroyOrder;

    @Property(hidden = true, defaultValue = "50", required = false)
    private int modifyOrder;

    /**
     * @return the createScript
     */
    public String getCreateScript() {
        return this.createScript;
    }

    /**
     * @return the destroyScript
     */
    public String getDestroyScript() {
        return this.destroyScript;
    }

    /**
     * @return the modifyScript
     */
    public String getModifyScript() {
        return this.modifyScript;
    }

    /**
     * @param installScript
     *            the createScript to set
     */
    public void setCreateScript(final String installScript) {
        this.createScript = installScript;
    }

    /**
     * @param uninstallScript
     *            the destroyScript to set
     */
    public void setDestroyScript(final String uninstallScript) {
        this.destroyScript = uninstallScript;
    }

    /**
     * @param updateScript
     *            the modifyScript to set
     */
    public void setModifyScript(final String updateScript) {
        this.modifyScript = updateScript;
    }

    public int getCreateOrder() {
		return createOrder;
	}

	public void setCreateOrder(int createOrder) {
		this.createOrder = createOrder;
	}

	public int getDestroyOrder() {
		return destroyOrder;
	}

	public void setDestroyOrder(int destroyOrder) {
		this.destroyOrder = destroyOrder;
	}

	public int getModifyOrder() {
		return modifyOrder;
	}

	public void setModifyOrder(int modifyOrder) {
		this.modifyOrder = modifyOrder;
	}

	/**
     * Define steps required to install this resource.
     * 
     * @param ctx
     *            Planning context used for this deployment.
     */
    @Create
    public void installResource(final DeploymentPlanningContext ctx) {
        if (StringUtils.isNotEmpty(this.createScript)) {
            ctx.addSteps(this.buildSteps(this.createScript, this.createOrder));
        }
    }

    /**
     * Define steps required to update this resource.
     * 
     * @param ctx
     *            Planning context used for this deployment.
     */
    @Modify
    public void updateResource(final DeploymentPlanningContext ctx) {
        if (StringUtils.isNotEmpty(this.modifyScript)) {
            ctx.addSteps(this.buildSteps(this.modifyScript, this.modifyOrder));
        } else {
            this.uninstallResource(ctx);
            this.installResource(ctx);
        }

    }

    /**
     * Define steps required to uninstall this resource.
     * 
     * @param ctx
     *            Planning context used for this deployment.
     */
    @Destroy
    public void uninstallResource(final DeploymentPlanningContext ctx) {
        if (StringUtils.isNotEmpty(this.destroyScript)) {
            ctx.addSteps(this.buildSteps(this.destroyScript, this.destroyOrder));
        }
    }

    /**
     * Task: reinstall. Use the install script to reinstall the deployed XML access script.
     * 
     * @return List of steps required to reinstall the XML access script.
     */
    @ControlTask(description = "Reinstall")
    public List<? extends Step> reinstall() {
        return this.buildSteps(this.createScript, this.createOrder);
    }

    /**
     * Factory method used to build the steps required to execute the supplied XML access script.
     * 
     * @param script
     *            Location of the XML access script to execute.
     * @param order
     *            The order at which the script should be executed
     * @return List of steps to execute.
     */
    protected List<Step> buildSteps(final String script, final int order) {
        return Collections.<Step> singletonList(new ExecuteXmlAccessConfigurationItemStep(script, order, this));
    }

}
