package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.Validate;

import com.crossingchannels.portal.websphere.ci.base.step.AbstractXmlAccessDeploymentStep;
import com.crossingchannels.portal.websphere.template.FreemarkerTemplateOnClasspathParser;
import com.crossingchannels.portal.websphere.template.TemplateParser;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;

/**
 * Step to execute a XML access script. The XML access scripts are located on the classpath.
 * 
 * @author fwiegerinck
 */
@SuppressWarnings("serial")
public class ExecuteXmlAccessConfigurationItemStep extends AbstractXmlAccessDeploymentStep {

    private static final String buildDescriptionAndValidateArguments(final String script, final Deployed<? extends Deployable, ? extends WpContainer> deployedCi) {
        // Preconditions
        Validate.notNull(script);
        Validate.notNull(deployedCi);

        return String.format("Execute XML access script: %s for CI: %s", script, deployedCi.getId());
    }

    /**
     * Store CI used during parsing of freemarker template.
     */
    private final Deployed<? extends Deployable, ? extends WpContainer> deployedCi;

    /**
     * Store script to execute.
     */
    private final String xmlAccessScript;
    
    /**
     * Store additional context elements
     */
    private final Map<String, Object> context = new HashMap<String, Object>();    

    /**
     * Initialize a new XML access executions step using a default order of 50.
     * 
     * @param script
     *            Path to the XML Access script to execute.
     * @param order
     * 			  Order used to determine location in execution plan.
     * @param deployedCi
     *            The Deployed CI associated with the step.
     */
    public ExecuteXmlAccessConfigurationItemStep(final String script, final int order, final Deployed<? extends Deployable, ? extends WpContainer> deployedCi) {
        this(script, deployedCi, order);
    }

    /**
     * Initialize a new XML access executions step.
     * 
     * @param script
     *            Path to the XML Access script to execute.
     * @param deployedCi
     *            The Deployed CI associated with the step.
     * @param order
     *            The order used to arrange the steps.
     */
    public ExecuteXmlAccessConfigurationItemStep(final String script, final Deployed<? extends Deployable, ? extends WpContainer> deployedCi, final int order) {

        super(ExecuteXmlAccessConfigurationItemStep.buildDescriptionAndValidateArguments(script, deployedCi), order);

        // Store values
        this.xmlAccessScript = script;
        this.deployedCi = deployedCi;

    }
    
    /**
     * Add object to the context used during execution of the step.
     * 
     * @param name
     *            Name used to put object into the context. Use this name to reference the object during parsing of the XML access template.
     * @param value
     *            The object added to the context.
     */
    public void addToStepContext(final String name, final Object value) {
    	this.context.put(name, value);
    }

    /**
     * Update the execution, not implemented.
     * 
     * @param context
     *             Context to update with
     */
    protected void updateExecutionContext(final Map<String, Object> context) {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StepExitCode execute(final ExecutionContext ctx) {

        final Map<String, Object> context = new HashMap<String, Object>(this.context);

        // Update context first
        this.updateExecutionContext(context);

        // Delegate to sub method
        if (this.executeXmlAccess(ctx, this.xmlAccessScript, this.deployedCi, context)) {
            return StepExitCode.SUCCESS;
        } else {
            return StepExitCode.FAIL;
        }
    }
    
	@Override
	protected TemplateParser getTemplateParser() {
		return FreemarkerTemplateOnClasspathParser.INSTANCE;
	}

}
