package ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecurityLevel;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubject;
import com.crossingchannels.portal.websphere.ci.portlet.types.LocalizedPortletInfo;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseEmbeddedDeployed;

/**
 * A base 'Deployed CI' used for portlets and cloned portlets.
 * 
 * @author fwiegerinck
 */
@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Portlet description", root=ConfigurationItemRoot.NESTED)
public class BasePortlet<D extends EmbeddedDeployable, C extends EmbeddedDeployedContainer<?, ?>> extends BaseEmbeddedDeployed<D, C> {

	@Property(label = "Preferences", required=false)
    private Map<String, String> preferences;
    
	@Property(label = "Unique name", required=false)
    private String uniqueName;
	
	@Property(label = "Default locale", category="Localization", description="Define the default locale for this portlet.", required=false)
	private String defaultLocale;

	@Property(label = "Portlet titles", category="Localization", description="Localized portlet titles. Key is language format according to XML specification.", required=false)
	private Map<String, String> localizedTitles;
    
	@Property(label = "Descriptions", category="Localization", description="Localized descriptions. Key is language format according to XML specification.", required=false)
	private Map<String, String> localizedDescriptions;

	@Property(label = "Keywords", category="Localization", description="Localized keywords. Key is language format according to XML specification.", required=false)
	private Map<String, String> localizedKeywords;

	@Property(label = "ACL mappings", category="Security", description="The ACL mappings to define the access rights to this resource.", required=false, asContainment=true)
	private Set<AbstractAclMapping> aclMapping; 
	
	public Map<String, String> getPreferences() {
		if ( this.preferences == null ) {
			this.preferences = Collections.<String, String>emptyMap();
		}
		return preferences;
	}

	public void setPreferences(Map<String, String> preferences) {
		this.preferences = preferences;
	}

	public String getUniqueName() {
		return uniqueName;
	}

	public void setUniqueName(String uniqueName) {
		this.uniqueName = uniqueName;
	}
	
	public String getDefaultLocale() {
		return defaultLocale;
	}

	public void setDefaultLocale(String defaultLocale) {
		this.defaultLocale = defaultLocale;
	}

	public Map<String, String> getLocalizedTitles() {
		if ( this.localizedTitles == null ) {
			this.localizedTitles = Collections.<String, String>emptyMap();
		}
		return localizedTitles;
	}

	public void setLocalizedTitles(Map<String, String> localizedTitles) {
		this.localizedTitles = localizedTitles;
	}

	public Map<String, String> getLocalizedDescriptions() {
		if ( this.localizedDescriptions == null ) {
			this.localizedDescriptions = Collections.<String, String>emptyMap();
		}
		return localizedDescriptions;
	}

	public void setLocalizedDescriptions(Map<String, String> localizedDescriptions) {
		this.localizedDescriptions = localizedDescriptions;
	}

	public Map<String, String> getLocalizedKeywords() {
		if ( this.localizedKeywords == null ) {
			this.localizedKeywords = Collections.<String, String>emptyMap();
		}
		return localizedKeywords;
	}

	public void setLocalizedKeywords(Map<String, String> localizedKeywords) {
		this.localizedKeywords = localizedKeywords;
	}

    public Set<LocalizedPortletInfo> getLocalizedPortletInfo() {
    	
    	final Map<String, String> localizedTitles = this.getLocalizedTitles();
    	final Map<String, String> localizedDescriptions = this.getLocalizedDescriptions();
    	final Map<String, String> localizedKeywords = this.getLocalizedKeywords();
    	
    	// Build set of all languages
    	final Set<String> languages = new HashSet<String>();
    	languages.addAll( localizedTitles.keySet() );
    	languages.addAll( localizedDescriptions.keySet() );
    	languages.addAll( localizedKeywords.keySet() );
    	
    	// Build set for localized portlet info
    	final Set<LocalizedPortletInfo> localizedPortletInfos = new HashSet<LocalizedPortletInfo>(languages.size());
    	for( String language : languages ) {
    		localizedPortletInfos.add(
    				new LocalizedPortletInfo(
    						language, 
    						npeSafeGet(localizedTitles, language), 
    						npeSafeGet(localizedDescriptions, language), 
    						npeSafeGet(localizedKeywords, language)
    					)
    			);
    	}
    	
    	return localizedPortletInfos;
    }

	public Set<AbstractAclMapping> getAclMapping() {
		if ( aclMapping == null ) {
			aclMapping = Collections.<AbstractAclMapping>emptySet();
		}
		return aclMapping;
	}

	public void setAclMapping(Set<AbstractAclMapping> aclMapping) {
		this.aclMapping = aclMapping;
	}

	/**
	 * Retrieve the merged ACL mappings as a map containing a collection of portal security subjects per portal security levels.
	 * 
	 * @return The map with merged ACL mappings.
	 */
	public Map<PortalSecurityLevel, Set<PortalSecuritySubject>> getMergedAclMapping() {
		
		final Map<PortalSecurityLevel, Set<PortalSecuritySubject>> mergedAclMapping = new HashMap<PortalSecurityLevel, Set<PortalSecuritySubject>>();
		
		// Add mappings one-by-one
		for( final AbstractAclMapping aclMappingCI : this.getAclMapping() ) {
			// Get mapping of CI
			Map<PortalSecurityLevel, Set<PortalSecuritySubject>> aclMapping = aclMappingCI.getMapping();
			
			// Merge per security level
			for( PortalSecurityLevel securityLevel : aclMapping.keySet() ) {
				
				// Get collection of subjects
				final Set<PortalSecuritySubject> subjects;
				if ( mergedAclMapping.containsKey(securityLevel) ) {
					subjects = mergedAclMapping.get(securityLevel);
				} else {
					subjects = new HashSet<PortalSecuritySubject>();
					mergedAclMapping.put(securityLevel, subjects);
				}
				
				// Add items
				subjects.addAll(aclMapping.get(securityLevel));
			}
			
		}
		
		return mergedAclMapping;
	}
	
	private String npeSafeGet(final Map<String, String> map, final String key ) {
		final String value;
		if ( map.containsKey(key) ) {
			value = map.get(key);
		} else {
			value = null;
		}
		return value;
	}
}
