package com.crossingchannels.portal.websphere.ci.portlet.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.crossingchannels.portal.websphere.model.BaseModelElement;

/**
 * @author FWiegerinck
 */
@SuppressWarnings("serial")
public class PortletApplication extends BaseModelElement {

    private final String name;

    private final String uniqueIdentifier;

    private final List<Portlet> portlets;

    /**
     * @param name
     * @param uniqueIdentifier
     */
    PortletApplication(final String name, final String uniqueIdentifier, final List<Portlet> portlets) {
        super();
        this.name = name;
        this.uniqueIdentifier = uniqueIdentifier;
        this.portlets = Collections.unmodifiableList(new ArrayList<Portlet>(portlets));
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * @return the portlets
     */
    public List<Portlet> getPortlets() {
        return this.portlets;
    }

    /**
     * @return the uniqueIdentifier
     */
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

}
