package com.crossingchannels.portal.websphere.ci.portlet.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.crossingchannels.portal.websphere.model.AbstractModelElementFactory;
import com.crossingchannels.portal.websphere.specification.jsr286.PortletDescriptor;

import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;

/**
 * Builder to create different types of model elements
 * 
 * @author FWiegerinck
 */
public class PortletApplicationBuilder extends AbstractModelElementFactory<PortletApplication> {

    /**
     * Create a PortletApplicationBuilder with the given portletDescriptor.
     * 
     * @param portletDescriptor
     *                     The description to use
     * @return a PortletApplicationBuilder
     */
    public static PortletApplicationBuilder create(final PortletDescriptor portletDescriptor) {
        return new PortletApplicationBuilder(portletDescriptor);
    }

    private final PortletDescriptor portletDescriptor;
	private Set<BasePortlet<?, ?>> portlets;
	private boolean autoScanForPortlets;

    /**
     * Hide constructor for utility/builder class
     */
    private PortletApplicationBuilder(final PortletDescriptor portletDescriptor) {
        super();

        // Store information
        this.portletDescriptor = portletDescriptor;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PortletApplication toModel() {
        // Retrieve all required information
        final List<Portlet> portlets = new ArrayList<Portlet>();

        // Create map with portletName-CI association.
        final Map<String, BasePortlet<?, ?>> portletMap = this.buildPortletMap();
        
        // Loop for each portlet within descriptor
        for (final String portletName : this.portletDescriptor.getPortletNames()) {
        	
        	// Add if autoscan is enabled or part of the set of CIs
        	if ( this.autoScanForPortlets || portletMap.containsKey(portletName) ) {
        		portlets.add(PortletBuilder.create(portletName).setCi(portletMap.get(portletName)).toModel());
        	}
        }

        // Do generate items
        return new PortletApplication(this.portletDescriptor.getName(), this.portletDescriptor.getUniqueIdentifier(), portlets);
    }

	public PortletApplicationBuilder withPortlets(final Set<BasePortlet<?, ?>> portlets, final boolean autoScanForPortlets) {
		this.portlets = portlets;
		this.autoScanForPortlets = autoScanForPortlets;
		
		return this;
	}

	private Map<String, BasePortlet<?, ?>> buildPortletMap() {
		final Map<String, BasePortlet<?, ?>> portletMap = new HashMap<String, BasePortlet<?, ?>>();
		
		for( BasePortlet<?, ?> portlet : this.portlets ) {
			final String name = portlet.getProperty("portletName");
			portletMap.put(name, portlet);
		}
		
		return portletMap;
	}
	
}
