package com.crossingchannels.portal.websphere.ci.portlet.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.crossingchannels.portal.websphere.model.BaseModelElement;

/**
 * @author FWiegerinck
 */
@SuppressWarnings("serial")
public class PortletArchive extends BaseModelElement {

    private final String locationOnDisk;

    /**
     * Store list of webmodules provided by this archive
     */
    private final List<WebModule> webModules;

    public PortletArchive(final String locationOnDisk, final List<WebModule> webModules) {
        this.locationOnDisk = locationOnDisk;
        this.webModules = Collections.unmodifiableList(new ArrayList<WebModule>(webModules));
    }

    /**
     * @return the locationOnDisk
     */
    public String getLocationOnDisk() {
        return this.locationOnDisk;
    }

    /**
     * @return the webModules
     */
    public List<WebModule> getWebModules() {
        return this.webModules;
    }

}
