package com.crossingchannels.portal.websphere.ci.portlet.model;

import java.util.HashSet;
import java.util.Set;

import com.crossingchannels.portal.websphere.model.AbstractModelElementFactory;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;

import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;

/**
 * Builder to create different types of model elements
 * 
 * @author FWiegerinck
 */
public class PortletBuilder extends AbstractModelElementFactory<Portlet> {

    public static PortletBuilder create(final String portletName) {
        return new PortletBuilder(portletName);
    }

    private final String portletName;
    private BasePortlet<?, ?> deployedPortletCi;

    /**
     * Hide constructor for utility/builder class
     */
    private PortletBuilder(final String portletName) {
        super();

        // Store information
        this.portletName = portletName;
    }
    
    public PortletBuilder setCi(BasePortlet<?, ?> deployedPortletCi) {
    	this.deployedPortletCi = deployedPortletCi;
    	
    	return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Portlet toModel() {
    	final BasePortlet<?, ?> portletCi;
    	if ( this.deployedPortletCi == null  ) {
    		portletCi = DescriptorRegistry.getDescriptor("wp.Portlet").newInstance();
    		portletCi.setProperty("portletName", this.portletName);
    	} else {
    		portletCi = this.deployedPortletCi; 
    	}
    	
    	final Set<ClonedPortlet> clonedPortlets = new HashSet<ClonedPortlet>();
    	for( BasePortlet<?,?> clonedPortletCi : this.deployedPortletCi.<Set<BasePortlet<?, ?>>>getProperty("clones")) {
    		clonedPortlets.add(ClonedPortletBuilder.create().setCi(clonedPortletCi).toModel());
    	}
    	
        // Do generate items
        return new Portlet(this.portletName, portletCi, clonedPortlets);
    }
}
