package com.crossingchannels.portal.websphere.util;

import java.util.HashSet;
import java.util.Set;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

/**
 * @author FWiegerinck
 * 
 */
public class ChangeNamespaceXmlFilter extends XMLFilterImpl {

    private final String targetNamespace;
    private final Set<String> compatibleNamespaces;

    /**
     * @param targetNamespace
     * @param compatibleNamespaces
     */
    public ChangeNamespaceXmlFilter(final String targetNamespace, final Set<String> compatibleNamespaces) {
        super();
        this.targetNamespace = targetNamespace;
        this.compatibleNamespaces = new HashSet<String>(compatibleNamespaces);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void startElement(final String uri, final String localName, final String qName, final Attributes atts) throws SAXException {
        if (this.compatibleNamespaces.contains(uri)) {
            super.startElement(this.targetNamespace, localName, qName, atts);
        } else {
            super.startElement(uri, localName, qName, atts);
        }

    }

}
