package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container;

import com.crossingchannels.portal.websphere.ci.generic.container.WpVersion;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;

/**
 * CI container to represent a cluster instance. This CI is an extension of the <code>Cluster</code> as defined within the WAS plugin.
 * 
 * @author fwiegerinck
 */
@Metadata(description = "A WebSphere Portal cluster managed by a deployment manager")
@SuppressWarnings("serial")
public class Cluster extends com.xebialabs.deployit.plugin.was.container.Cluster implements WpRuntimeContainer {

    @Property(label = "Version", description = "The version of WebSphere Portal.", category = "Portal", required = true)
    private WpVersion wpVersion;

    @Property(label = "Installation location", description = "Location of WebSphere Portal on the primary node.", category = "Portal", required = true)
    private String wpHome;

    @Property(label = "Administrative user", description = "Username of the administrative user.", category = "Portal", required = true)
    private String wpAdminUsername;

    @Property(label = "Administrative password", description = "Password of the administrative user.", category = "Portal", required = true, password = true)
    private String wpAdminPassword;

    @Property(label = "Configuration URL", description = "The URL of the WebSphere Portal configuration API.", category = "Portal", required = true)
    private String wpConfigUrl;

    @Property(label = "Primairy node host", description = "The host definition of the primary node.", category = "Portal", required = true)
    private Host wpPrimaryNodeHost;

    /**
     * {@inheritDoc}
     */
    @Override
    public WpVersion getWpVersion() {
        return this.wpVersion;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getWpHome() {
        return this.wpHome;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getWpAdminUsername() {
        return this.wpAdminUsername;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getWpAdminPassword() {
        return this.wpAdminPassword;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getWpConfigUrl() {
        return this.wpConfigUrl;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Host getHost() {
        return this.wpPrimaryNodeHost;
    }

    public void setWpVersion(final WpVersion wpVersion) {
        this.wpVersion = wpVersion;
    }

    public void setWpHome(final String wpHome) {
        this.wpHome = wpHome;
    }

    public void setWpAdminUsername(final String wpAdminUsername) {
        this.wpAdminUsername = wpAdminUsername;
    }

    public void setWpAdminPassword(final String wpAdminPassword) {
        this.wpAdminPassword = wpAdminPassword;
    }

    public void setWpConfigUrl(final String wpConfigUrl) {
        this.wpConfigUrl = wpConfigUrl;
    }

    public void setWpPrimaryNodeHost(final Host wpPrimaryNodeHost) {
        this.wpPrimaryNodeHost = wpPrimaryNodeHost;
    }

    @Override
    public WpRuntimeContainer getRuntimeContainer() {
        return this;
    }

}
