package ext.deployit.com.crossingchannels.portal.websphere.ci.generic.step;

import java.io.IOException;

import org.apache.commons.lang.Validate;

import com.crossingchannels.portal.websphere.ci.base.step.AbstractXmlAccessDeploymentStep;
import com.crossingchannels.portal.websphere.template.FreemarkerTemplateOnFilesystemParser;
import com.crossingchannels.portal.websphere.template.TemplateParser;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.deployed.DeployedXmlAccessScript;
import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;

/**
 * Step to execute a {@link BasePortlet}. The XML access scripts are part of the deployed CI.
 * 
 * @author fwiegerinck
 */
@SuppressWarnings("serial")
public class ExecuteXmlAccessScriptStep extends AbstractXmlAccessDeploymentStep {

    private static final String buildDescriptionAndValidateArguments(final String script, final Deployed<? extends Deployable, ? extends WpContainer> deployedCi) {
        // Preconditions
        Validate.notNull(script);
        Validate.notNull(deployedCi);

        return String.format("Execute XML access script: %s for CI: %s", script, deployedCi.getId());
    }

    /**
     * Store CI used during parsing of freemarker template.
     */
    private final DeployedXmlAccessScript deployedCi;

    /**
     * Store script to execute.
     */
    private final String xmlAccessScript;

    /**
     * Initialize a new XML access executions tep.
     * 
     * @param script
     *            Path to the XML Access script to execute.
     * @param order
     *            Order used to determine location in execution plan.
     * @param deployedCi
     *            The Deployed CI associated with the step.
     * @throws IOException
     */
    public ExecuteXmlAccessScriptStep(final String script, final int order, final DeployedXmlAccessScript deployedCi) throws IOException {

        super(ExecuteXmlAccessScriptStep.buildDescriptionAndValidateArguments(script, deployedCi), order);

        // Store values
        this.xmlAccessScript = script;
        this.deployedCi = deployedCi;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StepExitCode execute(final ExecutionContext ctx) {

        // Delegate to sub method
        if (this.executeXmlAccess(ctx, this.xmlAccessScript, this.deployedCi, this.deployedCi.getPlaceholders())) {
            return StepExitCode.SUCCESS;
        } else {
            return StepExitCode.FAIL;
        }
    }

	@Override
	protected TemplateParser getTemplateParser() {
		return FreemarkerTemplateOnFilesystemParser.INSTANCE;
	}

}
