/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.ci.portlet.model;

import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecurityLevel;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubject;
import com.crossingchannels.portal.websphere.ci.portlet.types.LocalizedPortletInfo;
import com.crossingchannels.portal.websphere.model.BaseModelElement;
import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.BasePortlet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class BasePortletModel
extends BaseModelElement {
    private final BasePortlet<?, ?> ci;

    BasePortletModel(BasePortlet<?, ?> portletCi) {
        Validate.notNull(portletCi);
        this.ci = portletCi;
    }

    public BasePortlet<?, ?> getCi() {
        return this.ci;
    }

    public String getUniqueName() {
        return this.ci.getUniqueName();
    }

    public Map<String, String> getPreferences() {
        return this.ci.getPreferences();
    }

    public String getDefaultLocale() {
        return this.ci.getDefaultLocale();
    }

    public Set<LocalizedPortletInfo> getLocalizedPortletInfo() {
        return this.ci.getLocalizedPortletInfo();
    }

    public Map<String, Set<PortalSecuritySubject>> getAclMapping() {
        Map<PortalSecurityLevel, Set<PortalSecuritySubject>> mapping = this.ci.getMergedAclMapping();
        if (mapping.containsKey((Object)PortalSecurityLevel.NONE)) {
            mapping.remove((Object)PortalSecurityLevel.NONE);
        }
        HashMap<String, Set<PortalSecuritySubject>> convertedMapping = new HashMap<String, Set<PortalSecuritySubject>>();
        for (Map.Entry<PortalSecurityLevel, Set<PortalSecuritySubject>> entry : mapping.entrySet()) {
            convertedMapping.put(entry.getKey().getXmlAccessName(), entry.getValue());
        }
        return convertedMapping;
    }
}

