/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.executor;

import com.crossingchannels.portal.websphere.executor.Executor;
import com.crossingchannels.portal.websphere.executor.XmlAccessExecutionException;
import com.crossingchannels.portal.websphere.specification.wp.dom.ObjectFactory;
import com.crossingchannels.portal.websphere.specification.wp.dom.Request;
import com.crossingchannels.portal.websphere.specification.wp.dom.StatusInfo;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.overthere.DefaultProcessOutputHandler;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.local.LocalConnection;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpRuntimeContainer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlAccessExecutor
implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlAccessExecutor.class);
    private static final Logger SCRIPTLOGGER = LoggerFactory.getLogger((String)"com.crossingchannels.portal.websphere.xmlaccess.scripts");
    public static final String XSD_FILENAME = "PortalConfig_6.1.0.xsd";
    public static final URL XSD_LOCATION = XmlAccessExecutor.class.getResource("/META-INF/xsd/PortalConfig_6.1.0.xsd");
    private static final String REQUESTSTATUS_FAILED = "FAILED";
    private static final String SCRIPTNAME_DOM_GENERATED = "--inline generated XML access based upon DOM structure--";
    private static JAXBContext JAXBCONTEXT;
    private final WpContainer container;

    public XmlAccessExecutor(WpContainer container) {
        Validate.notNull((Object)container);
        this.container = container;
    }

    public Request executeXmlAccess(ExecutionContext context, Request domObject) throws XmlAccessExecutionException {
        return this.executeXmlAccess(null, context, domObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request executeXmlAccess(OverthereConnection session, ExecutionContext context, Request domObject) throws XmlAccessExecutionException {
        if (context == null) {
            throw new IllegalArgumentException("Parameter \"context\" cannot be NULL");
        }
        if (domObject == null) {
            throw new IllegalArgumentException("Parameter \"domObject\" cannot be NULL");
        }
        OverthereConnection localConnection = LocalConnection.getLocalConnection();
        OverthereFile temporaryFile = null;
        try {
            temporaryFile = localConnection.getTempFile("xmlaccess-request-", ".xml");
            Marshaller marshaller = JAXBCONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)XSD_FILENAME);
            marshaller.marshal((Object)domObject, temporaryFile.getOutputStream());
            Request request = this.executeCmd(session, context, temporaryFile, SCRIPTNAME_DOM_GENERATED);
            return request;
        }
        catch (JAXBException e) {
            Request request = null;
            return request;
        }
        finally {
            if (temporaryFile != null && temporaryFile.exists()) {
                temporaryFile.delete();
            }
        }
    }

    public Request executeXmlAccess(ExecutionContext context, OverthereFile xmlaccessRequestFile, String scriptTemplateId) throws XmlAccessExecutionException {
        return this.executeXmlAccess(null, context, xmlaccessRequestFile, scriptTemplateId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request executeXmlAccess(OverthereConnection session, ExecutionContext context, OverthereFile xmlaccessRequestFile, String scriptTemplateId) throws XmlAccessExecutionException {
        if (context == null) {
            throw new IllegalArgumentException("Parameter \"context\" cannot be NULL");
        }
        if (xmlaccessRequestFile == null) {
            throw new IllegalArgumentException("Parameter \"xmlaccessRequestFile\" cannot be NULL");
        }
        if (xmlaccessRequestFile.exists()) {
            boolean xmlvalid;
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(XSD_LOCATION);
                unmarshaller.setSchema(schema);
                unmarshaller.unmarshal(xmlaccessRequestFile.getInputStream());
                xmlvalid = true;
            }
            catch (JAXBException je) {
                LOGGER.warn("Invalid XML Access Script found! Execution aborted...", (Throwable)je);
                if (LOGGER.isDebugEnabled()) {
                    try {
                        InputStream stream = xmlaccessRequestFile.getInputStream();
                        try {
                            String generatedXmlAccess = IOUtils.toString((InputStream)stream);
                            LOGGER.debug("The following XML access content is not valid: \n {}", (Object)generatedXmlAccess);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)stream);
                        }
                    }
                    catch (IOException ioe) {
                        LOGGER.debug("Unable to generate XML Access snippet due to an IOException", (Throwable)ioe);
                    }
                }
                xmlvalid = false;
            }
            catch (SAXException se) {
                LOGGER.warn("Invalid XML Access Script found! Execution aborted...", (Throwable)se);
                if (LOGGER.isDebugEnabled()) {
                    try {
                        InputStream stream = xmlaccessRequestFile.getInputStream();
                        try {
                            String generatedXmlAccess = IOUtils.toString((InputStream)stream);
                            LOGGER.debug("The following XML access content is not valid: \n {}", (Object)generatedXmlAccess);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)stream);
                        }
                    }
                    catch (IOException ioe) {
                        LOGGER.debug("Unable to generate XML Access snippet due to an IOException", (Throwable)ioe);
                    }
                }
                xmlvalid = false;
            }
            if (xmlvalid) {
                return this.executeCmd(session, context, xmlaccessRequestFile, scriptTemplateId);
            }
        }
        return null;
    }

    public boolean isSuccessfullyExecuted(Request xmlAccessResponse) {
        boolean successfull;
        if (xmlAccessResponse != null) {
            successfull = true;
            for (StatusInfo statusInfo : xmlAccessResponse.getStatus()) {
                if (!REQUESTSTATUS_FAILED.equalsIgnoreCase(statusInfo.getResult())) continue;
                successfull = false;
                break;
            }
        } else {
            successfull = false;
        }
        return successfull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request executeCmd(OverthereConnection session, ExecutionContext context, OverthereFile xmlaccessRequestFile, String scriptTemplateId) throws XmlAccessExecutionException {
        Request result;
        if (SCRIPTLOGGER.isTraceEnabled()) {
            InputStream inputStream = xmlaccessRequestFile.getInputStream();
            try {
                String templateContent = IOUtils.toString((InputStream)inputStream);
                ScriptUtils.dumpScript((String)scriptTemplateId, (String)templateContent, (Logger)SCRIPTLOGGER);
            }
            catch (IOException ioe) {
                LOGGER.warn(String.format("Unable to read XML access from file [%s]", xmlaccessRequestFile.getName()), (Throwable)ioe);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        if (session == null) {
            session = this.container.getRuntimeContainer().getHost().getConnection();
            try {
                result = this.__performExecute(session, context, xmlaccessRequestFile);
            }
            finally {
                session.close();
            }
        } else {
            result = this.__performExecute(session, context, xmlaccessRequestFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request __performExecute(OverthereConnection targetHostConnection, ExecutionContext ctx, OverthereFile xmlaccessRequestFile) throws XmlAccessExecutionException {
        WpRuntimeContainer runtimeContainer = this.container.getRuntimeContainer();
        this.log(ctx, "Copy XML Access to target.");
        OverthereFile executableScript = targetHostConnection.getTempFile("execute_xmlaccess", ".xml");
        xmlaccessRequestFile.copyTo(executableScript);
        this.log(ctx, MessageFormat.format("Finished coping XML Access to target. File is {0}", executableScript.getPath()));
        OverthereFile targetOutput = targetHostConnection.getTempFile("execute_xmlaccess", "_out.xml");
        StringBuilder xmlAccessCmd = new StringBuilder();
        xmlAccessCmd.append(runtimeContainer.getWpHome());
        xmlAccessCmd.append(targetHostConnection.getHostOperatingSystem().getFileSeparator());
        xmlAccessCmd.append("bin");
        xmlAccessCmd.append(targetHostConnection.getHostOperatingSystem().getFileSeparator());
        xmlAccessCmd.append("xmlaccess");
        xmlAccessCmd.append(targetHostConnection.getHostOperatingSystem().getScriptExtension());
        CmdLine commandLine = CmdLine.build((String[])new String[]{xmlAccessCmd.toString()});
        commandLine.addArgument("-url");
        commandLine.addArgument(this.container.getWpConfigUrl());
        commandLine.addArgument("-user");
        commandLine.addArgument(runtimeContainer.getWpAdminUsername());
        commandLine.addArgument("-password");
        commandLine.addPassword(runtimeContainer.getWpAdminPassword());
        commandLine.addArgument("-in");
        commandLine.addArgument(executableScript.getPath());
        commandLine.addArgument("-out");
        commandLine.addArgument(targetOutput.getPath());
        this.log(ctx, MessageFormat.format("Start XML Access script with command : {0}", commandLine.toCommandLine(targetHostConnection.getHostOperatingSystem(), true)));
        int executionResult = targetHostConnection.execute((OverthereProcessOutputHandler)new DefaultProcessOutputHandler(ctx), commandLine);
        if (executionResult == 0 || executionResult == 1) {
            InputStream input = targetOutput.getInputStream();
            try {
                String xmlAccessOutput = IOUtils.toString((InputStream)input);
                ctx.logOutput(String.format("XMLAccess response:\n%s", xmlAccessOutput));
                LOGGER.debug("Remote response: {}", (Object)xmlAccessOutput);
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to catch output response for logging", (Throwable)ioe);
                ctx.logError("Unable to retrieve XML Access response due to an exception", (Throwable)ioe);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
            if (LOGGER.isDebugEnabled()) {
                // empty if block
            }
            Request returnValue = null;
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                Object unmarshalledObject = unmarshaller.unmarshal(targetOutput.getInputStream());
                if (unmarshalledObject instanceof Request) {
                    returnValue = (Request)unmarshalledObject;
                }
                this.log(ctx, "Finished executing XML Access script");
            }
            catch (JAXBException e) {
                new XmlAccessExecutionException("Unable to process result due to JAXException. XML Access script already executed!", e);
            }
            return returnValue;
        }
        this.logError(ctx, MessageFormat.format("Unable to execute XML Access script due to error code {0}", executionResult));
        return null;
    }

    private void log(ExecutionContext ctx, String message) {
        ctx.logOutput(message);
        LOGGER.debug(message);
    }

    private void logError(ExecutionContext ctx, String message) {
        ctx.logError(message);
        LOGGER.error(message);
    }

    static {
        try {
            JAXBCONTEXT = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException je) {
            throw new RuntimeException("Unable to initialize JAXB context for XmlAccess", je);
        }
    }
}

