/*
 * Decompiled with CFR 0.152.
 */
package com.crossingchannels.portal.websphere.ci.base.step;

import com.crossingchannels.portal.websphere.ci.base.step.AbstractDeploymentStep;
import com.crossingchannels.portal.websphere.executor.ExecutorFactory;
import com.crossingchannels.portal.websphere.executor.XmlAccessExecutionException;
import com.crossingchannels.portal.websphere.executor.XmlAccessExecutor;
import com.crossingchannels.portal.websphere.specification.wp.dom.Request;
import com.crossingchannels.portal.websphere.template.TemplateParseException;
import com.crossingchannels.portal.websphere.template.TemplateParser;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import ext.deployit.com.crossingchannels.portal.websphere.ci.generic.container.WpContainer;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlAccessDeploymentStep
extends AbstractDeploymentStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXmlAccessDeploymentStep.class);

    public AbstractXmlAccessDeploymentStep(String description, int order) {
        super(description, order);
    }

    protected abstract TemplateParser getTemplateParser();

    protected boolean executeXmlAccess(ExecutionContext ctx, String xmlAccessScript, Deployed<? extends Deployable, ? extends WpContainer> deployedCi, Map<String, ?> parseContext) {
        Validate.notNull((Object)ctx);
        Validate.notNull((Object)xmlAccessScript);
        Validate.notNull(deployedCi);
        Validate.notNull(parseContext);
        ctx.logOutput("Start generating XML Access for execution.");
        OverthereFile parsedScript = this.parseScript(xmlAccessScript, deployedCi, parseContext);
        ctx.logOutput("Finished generating XML Access for execution.");
        XmlAccessExecutor executor = ExecutorFactory.INSTANCE.createXmlAccessExecutor((WpContainer)deployedCi.getContainer());
        try {
            Request returnedDom = executor.executeXmlAccess(ctx, parsedScript, xmlAccessScript);
            if (returnedDom != null && executor.isSuccessfullyExecuted(returnedDom)) {
                ctx.logOutput(MessageFormat.format("\nExecuted script ({0}) for CI({1}) successfully!", xmlAccessScript, deployedCi.getId()));
                return true;
            }
            ctx.logError(MessageFormat.format("\nUnable to execute script ({0}) for CI ({1})", xmlAccessScript, deployedCi.getId()));
            return false;
        }
        catch (XmlAccessExecutionException xaee) {
            ctx.logError(MessageFormat.format("\nUnable to execute script ({0}) for CI ({1})", xmlAccessScript, deployedCi.getId()), (Throwable)xaee);
            return false;
        }
    }

    private OverthereFile parseScript(String xmlAccessScript, Deployed<? extends Deployable, ? extends Container> deployedCi, Map<String, ?> parseContext) {
        OverthereConnection local = LocalConnection.getLocalConnection();
        OverthereFile temporaryFile = local.getTempFile("execute_xmlaccess", ".xml");
        LOGGER.debug("Use temporary file {} to parse template", (Object)temporaryFile.toString());
        try (OutputStream temporaryFileOutputStream = temporaryFile.getOutputStream();){
            this.getTemplateParser().parse(xmlAccessScript, deployedCi, parseContext, temporaryFileOutputStream);
        }
        catch (TemplateParseException tpe) {
            throw new RuntimeException("Unable to parse template", tpe);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception opening temporary file", e);
        }
        return temporaryFile;
    }
}

