/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed;

import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecurityLevel;
import com.crossingchannels.portal.websphere.ci.generic.types.PortalSecuritySubject;
import com.crossingchannels.portal.websphere.ci.portlet.types.LocalizedPortletInfo;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseEmbeddedDeployed;
import ext.deployit.com.crossingchannels.portal.websphere.ci.portlet.deployed.AbstractAclMapping;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Metadata(virtual=true, description="Portlet description", root=Metadata.ConfigurationItemRoot.NESTED)
public class BasePortlet<D extends EmbeddedDeployable, C extends EmbeddedDeployedContainer<?, ?>>
extends BaseEmbeddedDeployed<D, C> {
    @Property(label="Preferences", required=false)
    private Map<String, String> preferences;
    @Property(label="Unique name", required=false)
    private String uniqueName;
    @Property(label="Default locale", category="Localization", description="Define the default locale for this portlet.", required=false)
    private String defaultLocale;
    @Property(label="Portlet titles", category="Localization", description="Localized portlet titles. Key is language format according to XML specification.", required=false)
    private Map<String, String> localizedTitles;
    @Property(label="Descriptions", category="Localization", description="Localized descriptions. Key is language format according to XML specification.", required=false)
    private Map<String, String> localizedDescriptions;
    @Property(label="Keywords", category="Localization", description="Localized keywords. Key is language format according to XML specification.", required=false)
    private Map<String, String> localizedKeywords;
    @Property(label="ACL mappings", category="Security", description="The ACL mappings to define the access rights to this resource.", required=false, asContainment=true)
    private Set<AbstractAclMapping> aclMapping;

    public Map<String, String> getPreferences() {
        if (this.preferences == null) {
            this.preferences = Collections.emptyMap();
        }
        return this.preferences;
    }

    public void setPreferences(Map<String, String> preferences) {
        this.preferences = preferences;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public Map<String, String> getLocalizedTitles() {
        if (this.localizedTitles == null) {
            this.localizedTitles = Collections.emptyMap();
        }
        return this.localizedTitles;
    }

    public void setLocalizedTitles(Map<String, String> localizedTitles) {
        this.localizedTitles = localizedTitles;
    }

    public Map<String, String> getLocalizedDescriptions() {
        if (this.localizedDescriptions == null) {
            this.localizedDescriptions = Collections.emptyMap();
        }
        return this.localizedDescriptions;
    }

    public void setLocalizedDescriptions(Map<String, String> localizedDescriptions) {
        this.localizedDescriptions = localizedDescriptions;
    }

    public Map<String, String> getLocalizedKeywords() {
        if (this.localizedKeywords == null) {
            this.localizedKeywords = Collections.emptyMap();
        }
        return this.localizedKeywords;
    }

    public void setLocalizedKeywords(Map<String, String> localizedKeywords) {
        this.localizedKeywords = localizedKeywords;
    }

    public Set<LocalizedPortletInfo> getLocalizedPortletInfo() {
        Map<String, String> localizedTitles = this.getLocalizedTitles();
        Map<String, String> localizedDescriptions = this.getLocalizedDescriptions();
        Map<String, String> localizedKeywords = this.getLocalizedKeywords();
        HashSet<String> languages = new HashSet<String>();
        languages.addAll(localizedTitles.keySet());
        languages.addAll(localizedDescriptions.keySet());
        languages.addAll(localizedKeywords.keySet());
        HashSet<LocalizedPortletInfo> localizedPortletInfos = new HashSet<LocalizedPortletInfo>(languages.size());
        for (String language : languages) {
            localizedPortletInfos.add(new LocalizedPortletInfo(language, this.npeSafeGet(localizedTitles, language), this.npeSafeGet(localizedDescriptions, language), this.npeSafeGet(localizedKeywords, language)));
        }
        return localizedPortletInfos;
    }

    public Set<AbstractAclMapping> getAclMapping() {
        if (this.aclMapping == null) {
            this.aclMapping = Collections.emptySet();
        }
        return this.aclMapping;
    }

    public void setAclMapping(Set<AbstractAclMapping> aclMapping) {
        this.aclMapping = aclMapping;
    }

    public Map<PortalSecurityLevel, Set<PortalSecuritySubject>> getMergedAclMapping() {
        HashMap<PortalSecurityLevel, Set<PortalSecuritySubject>> mergedAclMapping = new HashMap<PortalSecurityLevel, Set<PortalSecuritySubject>>();
        for (AbstractAclMapping aclMappingCI : this.getAclMapping()) {
            Map<PortalSecurityLevel, Set<PortalSecuritySubject>> aclMapping = aclMappingCI.getMapping();
            for (PortalSecurityLevel securityLevel : aclMapping.keySet()) {
                Set subjects;
                if (mergedAclMapping.containsKey((Object)securityLevel)) {
                    subjects = (Set)mergedAclMapping.get((Object)securityLevel);
                } else {
                    subjects = new HashSet();
                    mergedAclMapping.put(securityLevel, subjects);
                }
                subjects.addAll(aclMapping.get((Object)securityLevel));
            }
        }
        return mergedAclMapping;
    }

    private String npeSafeGet(Map<String, String> map, String key) {
        String value = map.containsKey(key) ? map.get(key) : null;
        return value;
    }
}

