/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.LoginProvider;
import com.xebialabs.deployit.spring.HoconPropertySourceFactory;
import com.xebialabs.platform.sso.oidc.authentication.CustomJwtAuthenticationConverter;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.service.XLOidcUserService;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xldeploy.auth.oidc.web.XlDeployLoginFormFilter;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@EnableWebSecurity
@Configuration
@PropertySource(factory=HoconPropertySourceFactory.class, value={"conf/xl-deploy.conf"})
@ScalaSignature(bytes="\u0006\u0001\r%b\u0001\u0002\u0010 \u00011BQa\u000f\u0001\u0005\u0002qBQa\u0010\u0001\u0005\u0002\u0001CQ!\u0015\u0001\u0005\u0002ICQ\u0001\u0019\u0001\u0005\u0002ICQA\u0019\u0001\u0005\u0002\rDQ!\u001d\u0001\u0005\u0002IDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!a,\u0001\t\u0003\t\t\fC\u0004\u0002B\u0002!\t!a1\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005{AqA!\u0014\u0001\t\u0003\u0011y\u0005C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\t\r\u0005\u0001\"\u0003\u0003\u0006\"9!q\u0011\u0001\u0005\n\t%\u0005b\u0002BM\u0001\u0011%!1\u0014\u0005\b\u0005W\u0003A\u0011\u0002BW\u0011\u001d\u00119\r\u0001C\u0005\u0005\u0013DqA!6\u0001\t\u0013\u00119\u000eC\u0004\u0003f\u0002!IAa:\u0003'=\u0003XM\\%e\u0007>tg.Z2u\u0007>tg-[4\u000b\u0005\u0001\n\u0013\u0001B2p]\u001aT!AI\u0012\u0002\t=LGm\u0019\u0006\u0003I\u0015\na\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002'O\u0005A\u0001\u0010\u001c3fa2|\u0017P\u0003\u0002)S\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002U\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!\u0014(D\u00016\u0015\t1t'A\u0003tY\u001a$$NC\u00019\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001e6\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u001f\u0011\u0005y\u0002Q\"A\u0010\u0002\u0015=LGmY\"p]\u001aLw-F\u0001B!\tq$)\u0003\u0002D?\tQq*\u001b3d\u0007>tg-[4)\u0005\t)\u0005C\u0001$P\u001b\u00059%B\u0001%J\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0015.\u000bqaY8oi\u0016DHO\u0003\u0002M\u001b\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001O\u0003\ry'oZ\u0005\u0003!\u001e\u0013AAQ3b]\u0006\tr.\u001b3d\u0019><\u0017N\u001c)s_ZLG-\u001a:\u0016\u0003M\u0003\"\u0001V/\u000e\u0003US!AV,\u0002\u0007\u0011$xN\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005i[\u0016\u0001B2pe\u0016T!\u0001X\u0014\u0002\u0011\u0011,\u0007\u000f\\8zSRL!AX+\u0003\u001b1{w-\u001b8Qe>4\u0018\u000eZ3sQ\t\u0019Q)\u0001\nm_\u000e\fG\u000eT8hS:\u0004&o\u001c<jI\u0016\u0014\bF\u0001\u0003F\u0003q\u0019G.[3oiJ+w-[:ue\u0006$\u0018n\u001c8SKB|7/\u001b;pef,\u0012\u0001\u001a\t\u0003K:l\u0011A\u001a\u0006\u0003O\"\fAB]3hSN$(/\u0019;j_:T!!\u001b6\u0002\r\rd\u0017.\u001a8u\u0015\tYG.\u0001\u0004pCV$\bN\r\u0006\u0003[.\u000b\u0001b]3dkJLG/_\u0005\u0003_\u001a\u0014A%\u00138NK6|'/_\"mS\u0016tGOU3hSN$(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\u0015\u0003\u000b\u0015\u000b\u0001e\u00197bS6\u001cHk\\$sC:$X\rZ!vi\"|'/\u001b;jKN\u0004v\u000e\\5dsV\t1\u000f\u0005\u0002u}6\tQO\u0003\u0002wo\u0006!\u0011.\u001c9m\u0015\tA\u00180\u0001\u0004q_2L7-\u001f\u0006\u0003EiT!a\u001f?\u0002\u0007M\u001cxN\u0003\u0002~O\u0005A\u0001\u000f\\1uM>\u0014X.\u0003\u0002\u0000k\n9C)\u001a4bk2$8\t\\1j[N$vn\u0012:b]R,G-Q;uQ>\u0014\u0018\u000e^5fgB{G.[2zQ\t1Q)\u0001\u0012dkN$x.\\!vi\"|'/\u001b>bi&|gNU3rk\u0016\u001cHOU3t_24XM\u001d\u000b\u0005\u0003\u000f\t\u0019\u0002\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti!_\u0001\u0004o\u0016\u0014\u0017\u0002BA\t\u0003\u0017\u0011!eQ;ti>l\u0017)\u001e;i_JL'0\u0019;j_:\u0014V-];fgR\u0014Vm]8mm\u0016\u0014\bB\u00022\b\u0001\u0004\t)\u0002E\u0002f\u0003/I1!!\u0007g\u0005q\u0019E.[3oiJ+w-[:ue\u0006$\u0018n\u001c8SKB|7/\u001b;pefD3aBA\u000f!\u0011\ty\"a\u000b\u000e\u0005\u0005\u0005\"b\u0001%\u0002$)!\u0011QEA\u0014\u0003\u001d1\u0017m\u0019;pefT1!!\u000bL\u0003\u0015\u0011W-\u00198t\u0013\u0011\ti#!\t\u0003\u0013\u0005+Ho\\<je\u0016$\u0007FA\u0004F\u0003]\tW\u000f\u001e5pe&TX\rZ\"mS\u0016tGoU3sm&\u001cW\r\u0006\u0003\u00026\u0005u\u0002\u0003BA\u001c\u0003si\u0011\u0001[\u0005\u0004\u0003wA'!J%o\u001b\u0016lwN]=P\u0003V$\bNM!vi\"|'/\u001b>fI\u000ec\u0017.\u001a8u'\u0016\u0014h/[2f\u0011\u0019\u0011\u0007\u00021\u0001\u0002\u0016!\u001a\u0001\"!\b)\u0005!)\u0015!\u0005=m\u001f&$7-V:feN+'O^5dKR!\u0011qIA*!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA's\u000691/\u001a:wS\u000e,\u0017\u0002BA)\u0003\u0017\u0012\u0011\u0003\u0017'PS\u0012\u001cWk]3s'\u0016\u0014h/[2f\u0011\u0019\t\u0018\u00021\u0001\u0002VA!\u0011qKA-\u001b\u00059\u0018bAA.o\n\u00013\t\\1j[N$vn\u0012:b]R,G-Q;uQ>\u0014\u0018\u000e^5fgB{G.[2zQ\rI\u0011Q\u0004\u0015\u0003\u0013\u0015\u000b!$Y;uQ>\u0014\u0018N_3e\u00072LWM\u001c;SKB|7/\u001b;pef$B!!\u001a\u0002pA!\u0011qMA6\u001b\t\tIGC\u0002\u0002\u000e!LA!!\u001c\u0002j\t1\u0014)\u001e;iK:$\u0018nY1uK\u0012\u0004&/\u001b8dSB\fGnT!vi\"\u0014\u0014)\u001e;i_JL'0\u001a3DY&,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\"9\u0011\u0011\u0007\u0006A\u0002\u0005E\u0004\u0003BA\u001c\u0003gJ1!!\u001ei\u0005uy\u0015)\u001e;ie\u0005+H\u000f[8sSj,Gm\u00117jK:$8+\u001a:wS\u000e,\u0007f\u0001\u0006\u0002\u001e!\u0012!\"R\u0001\u0016S\u0012$vn[3o\t\u0016\u001cw\u000eZ3s\r\u0006\u001cGo\u001c:z+\t\ty\b\u0005\u0004\u0002\u0002\u0006\u001d\u00151R\u0007\u0003\u0003\u0007S1!!\"k\u0003\rQw\u000f^\u0005\u0005\u0003\u0013\u000b\u0019IA\tKoR$UmY8eKJ4\u0015m\u0019;pef\u00042!ZAG\u0013\r\tyI\u001a\u0002\u0013\u00072LWM\u001c;SK\u001eL7\u000f\u001e:bi&|g\u000e\u000b\u0002\f\u000b\u0006Q!n\u001e;EK\u000e|G-\u001a:\u0016\u0005\u0005]\u0005\u0003BAA\u00033KA!a'\u0002\u0004\nQ!j\u001e;EK\u000e|G-\u001a:)\u00051)\u0015A\u00076xi\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u000e{gN^3si\u0016\u0014XCAAR!\u0011\t)+!+\u000e\u0005\u0005\u001d&B\u0001\u0013z\u0013\u0011\tY+a*\u0003A\r+8\u000f^8n\u0015^$\u0018)\u001e;iK:$\u0018nY1uS>t7i\u001c8wKJ$XM\u001d\u0015\u0003\u001b\u0015\u000bA%Y;uQ>\u0014\u0018N_1uS>t7i\u001c3f)>\\WM\u001c*fgB|gn]3DY&,g\u000e^\u000b\u0003\u0003g\u0003B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0004\u0003sC\u0017\u0001C3oIB|\u0017N\u001c;\n\t\u0005u\u0016q\u0017\u0002,\t\u00164\u0017-\u001e7u\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8D_\u0012,Gk\\6f]J+7\u000f]8og\u0016\u001cE.[3oi\"\u0012a\"R\u0001\u0018_&$7\rT8hS:4\u0015-\u001b7ve\u0016D\u0015M\u001c3mKJ,\"!!2\u0011\t\u0005\u001d\u0017QZ\u0007\u0003\u0003\u0013T1\u0001JAf\u0015\r\ti\u0001\\\u0005\u0005\u0003\u001f\fIM\u0001\u000fBkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3IC:$G.\u001a:)\u0005=)\u0015A\u0006=mI2{w-\u001b8GC&dWO]3IC:$G.\u001a:\u0016\u0005\u0005]\u0007\u0003BAd\u00033LA!a7\u0002J\n)3+[7qY\u0016,&\u000f\\!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a%b]\u0012dWM\u001d\u0015\u0003!\u0015\u000b!d\u001c9f]&#Gj\\4pkR\u001cVoY2fgND\u0015M\u001c3mKJ$B!a9\u0002jB!\u0011\u0011BAs\u0013\u0011\t9/a\u0003\u00031=KGm\u0019'pO>,HoU;dG\u0016\u001c8\u000fS1oI2,'\u000f\u0003\u0004c#\u0001\u0007\u0011Q\u0003\u0015\u0004#\u0005u\u0001FA\tF\u0003Q\u0011W/\u001b7e\u0019><\u0017N\u001c$pe64\u0015\u000e\u001c;feR1\u00111\u001fB\u0002\u0005#\u0001B!!>\u0002\u00006\u0011\u0011q\u001f\u0006\u0005\u0003\u001b\tIPC\u0002#\u0003wT1!!@&\u0003\u0011\tW\u000f\u001e5\n\t\t\u0005\u0011q\u001f\u0002\u001812$U\r\u001d7ps2{w-\u001b8G_Jlg)\u001b7uKJDqA!\u0002\u0013\u0001\u0004\u00119!A\u000bbkRDWM\u001c;jG\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0011\t\t%!QB\u0007\u0003\u0005\u0017Q!\u0001\n7\n\t\t=!1\u0002\u0002\u0016\u0003V$\b.\u001a8uS\u000e\fG/[8o\u001b\u0006t\u0017mZ3s\u0011\u001d\u0011\u0019B\u0005a\u0001\u0005+\tQd]3tg&|g.Q;uQ\u0016tG/[2bi&|gn\u0015;sCR,w-\u001f\t\u0005\u0005/\u0011i\"\u0004\u0002\u0003\u001a)!!1DAe\u0003\u001d\u0019Xm]:j_:LAAa\b\u0003\u001a\ti2+Z:tS>t\u0017)\u001e;iK:$\u0018nY1uS>t7\u000b\u001e:bi\u0016<\u00170\u0001\feK\u001a\fW\u000f\u001c;M_\u001eLgNR8s[\u001aKG\u000e^3s)\u0019\t\u0019P!\n\u0003(!9!QA\nA\u0002\t\u001d\u0001b\u0002B\n'\u0001\u0007!Q\u0003\u0015\t\u0005O\u0011YC!\r\u00034A!\u0011q\u0004B\u0017\u0013\u0011\u0011y#!\t\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017E\u0001B\u001b\u0003u!WMZ1vYR\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cFO]1uK\u001eL\bfA\n\u0002\u001e!\u00121#R\u0001\u0014GN\u0014h\rT8hS:4uN]7GS2$XM\u001d\u000b\u0007\u0003g\u0014yD!\u0011\t\u000f\t\u0015A\u00031\u0001\u0003\b!9!1\u0003\u000bA\u0002\tU\u0001\u0006\u0003B!\u0005W\u0011\tD!\u0012\"\u0005\t\u001d\u0013AG2te\u001a\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cFO]1uK\u001eL\bf\u0001\u000b\u0002\u001e!\u0012A#R\u0001!Y><\u0017N\\+sY\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u0016sGO]=Q_&tG/\u0006\u0002\u0003RA!\u0011q\u0019B*\u0013\u0011\u0011)&!3\u0003A1{w-\u001b8Ve2\fU\u000f\u001e5f]RL7-\u0019;j_:,e\u000e\u001e:z!>Lg\u000e\u001e\u0015\u0003+\u0015\u000b1\u0005Z3gCVdGoT5eG6+8\u000f^1dQ\u0016$V-\u001c9mCR,7+\u001a;uS:<7/\u0006\u0002\u0003^AA!q\fB5\u0005[\u0012i'\u0004\u0002\u0003b)!!1\rB3\u0003\u0011)H/\u001b7\u000b\u0005\t\u001d\u0014\u0001\u00026bm\u0006LAAa\u001b\u0003b\t\u0019Q*\u00199\u0011\t\t=$Q\u0010\b\u0005\u0005c\u0012I\bE\u0002\u0003t=j!A!\u001e\u000b\u0007\t]4&\u0001\u0004=e>|GOP\u0005\u0004\u0005wz\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0003\u0000\t\u0005%AB*ue&twMC\u0002\u0003|=\n!c\u00197jK:$(+Z4jgR\u0014\u0018\r^5p]V\u0011\u00111R\u0001\u001dO\u0016$8\t\\5f]R\u0014VmZ5tiJ\fG/[8o\u0005VLG\u000eZ3s+\t\u0011Y\t\u0005\u0003\u0003\u000e\nMebA3\u0003\u0010&\u0019!\u0011\u00134\u0002%\rc\u0017.\u001a8u%\u0016<\u0017n\u001d;sCRLwN\\\u0005\u0005\u0005+\u00139JA\u0004Ck&dG-\u001a:\u000b\u0007\tEe-\u0001\rdY&,g\u000e\u001e%uiB\u0014V-];fgR4\u0015m\u0019;pef,\"A!(\u0011\t\t}%qU\u0007\u0003\u0005CS1!\u001bBR\u0015\r\u0011)kS\u0001\u0005QR$\b/\u0003\u0003\u0003*\n\u0005&\u0001G\"mS\u0016tG\u000f\u0013;uaJ+\u0017/^3ti\u001a\u000b7\r^8ss\u0006yq-\u001a;KoN\fEnZ8sSRDW\u000e\u0006\u0004\u00030\n}&1\u0019\t\u0005\u0005c\u0013Y,\u0004\u0002\u00034*!!Q\u0017B\\\u0003\rQwo\u001d\u0006\u0004\u0005sS\u0017\u0001\u00026pg\u0016LAA!0\u00034\na!j^:BY\u001e|'/\u001b;i[\"9!\u0011\u0019\u000eA\u0002\t5\u0014\u0001\u00046xg\u0006cwm\u001c:ji\"l\u0007b\u0002Bc5\u0001\u0007!QN\u0001\raJ|\u0007/\u001a:us:\u000bW.Z\u0001\u0014O\u0016$8\t\\5f]R\fU\u000f\u001e5NKRDw\u000eZ\u000b\u0003\u0005\u0017\u0004BA!4\u0003R6\u0011!q\u001a\u0006\u00035*LAAa5\u0003P\nQ2\t\\5f]R\fU\u000f\u001e5f]RL7-\u0019;j_:lU\r\u001e5pI\u0006Qr-\u001a;KoR|\u0015)\u001e;ieQ{7.\u001a8WC2LG-\u0019;peV\u0011!\u0011\u001c\t\u0007\u0005\u001b\u0014YNa8\n\t\tu'q\u001a\u0002\u0015\u001f\u0006+H\u000f\u001b\u001aU_.,gNV1mS\u0012\fGo\u001c:\u0011\t\u0005\u0005%\u0011]\u0005\u0005\u0005G\f\u0019IA\u0002KoR\f\u0011D^1mS\u0012\fG/Z(jI\u000e\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u0011!\u0011\u001e\t\u0004]\t-\u0018b\u0001Bw_\t!QK\\5uQ-\u0001!\u0011_A\u0013\u0005o\u0014\td!\u0002\u0011\u0007\u0019\u0013\u00190C\u0002\u0003v\u001e\u0013a\u0002\u0015:pa\u0016\u0014H/_*pkJ\u001cWm\t\u0002\u0003zB!!1`B\u0001\u001b\t\u0011iPC\u0002\u0003\u0000n\u000baa\u001d9sS:<\u0017\u0002BB\u0002\u0005{\u0014!\u0004S8d_:\u0004&o\u001c9feRL8k\\;sG\u00164\u0015m\u0019;pefd#aa\u0002\"\u0005\r%\u0011aE2p]\u001a|\u0003\u0010\\\u0017eKBdw.\u001f\u0018d_:4\u0007f\u0001\u0001\u0004\u000eA\u0019aia\u0004\n\u0007\rEqIA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0015\u0004\u0001\rU\u0001\u0003BB\f\u0007Ki!a!\u0007\u000b\t\rm1QD\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\t\u000551q\u0004\u0006\u0004\u0011\u000e\u0005\"bAB\u0012Y\u000611m\u001c8gS\u001eLAaa\n\u0004\u001a\t\tRI\\1cY\u0016<VMY*fGV\u0014\u0018\u000e^=")
public class OpenIdConnectConfig
implements Logging {
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        OpenIdConnectConfig openIdConnectConfig = this;
        synchronized (openIdConnectConfig) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic("xl-deploy.conf"));
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), new StringBuilder(1).append(".").append(this.oidcConfig().external_login()).toString(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    public InMemoryClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration()});
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    @Autowired
    public CustomAuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    @Bean
    @Autowired
    public InMemoryOAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XLOidcUserService xlOidcUserService(ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XLOidcUserService(claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        void var3_3;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().idTokenJWSAlg(), "idTokenJWSAlg");
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(clientRegistration -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public JwtDecoder jwtDecoder() {
        void var3_9;
        NimbusJwtDecoder nimbusJwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.oidcConfig().accessTokenJWSAlg(), "jwsAlg");
        JwsAlgorithm jwsAlgorithm2 = jwsAlgorithm;
        if (jwsAlgorithm2 instanceof SignatureAlgorithm) {
            SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)jwsAlgorithm2;
            String jwkSetUri = Strings.isNotBlank((String)this.oidcConfig().accessTokenKeyUri()) ? this.oidcConfig().accessTokenKeyUri() : this.clientRegistration().getProviderDetails().getJwkSetUri();
            nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(signatureAlgorithm).build();
        } else if (jwsAlgorithm2 instanceof MacAlgorithm) {
            MacAlgorithm macAlgorithm = (MacAlgorithm)jwsAlgorithm2;
            scala.collection.immutable.Map mappings = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS256), (Object)"HmacSHA256"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS384), (Object)"HmacSHA384"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MacAlgorithm.HS512), (Object)"HmacSHA512")}));
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenSecretKey()), (String)"No configuration setting found for key 'xl.security.auth.providers.oidc.access-token.secretKey'", (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.oidcConfig().accessTokenSecretKey().getBytes(StandardCharsets.UTF_8), (String)mappings.get((Object)macAlgorithm));
            nimbusJwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm(macAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException("Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.");
        }
        NimbusJwtDecoder jwtDecoder = nimbusJwtDecoder;
        jwtDecoder.setJwtValidator(this.getJwtOAuth2TokenValidator());
        return var3_9;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public CustomJwtAuthenticationConverter jwtAuthenticationConverter() {
        void var1_1;
        CustomJwtAuthenticationConverter jwtAuthenticationConverter = new CustomJwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.oidcConfig().userNameClaimName());
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor((ClaimsToGrantedAuthoritiesPolicy)this.claimsToGrantedAuthoritiesPolicy()));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient() {
        void var3_3;
        ListBuffer messageConverter = new ListBuffer();
        messageConverter.$plus$eq((Object)new FormHttpMessageConverter());
        messageConverter.$plus$eq((Object)new OAuth2AccessTokenResponseHttpMessageConverter());
        RestTemplate restTemplate = new RestTemplate((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)messageConverter.toList()).asJava());
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        return var3_3;
    }

    @Bean
    public AuthenticationFailureHandler oidcLoginFailureHandler() {
        return (request, response, exception) -> response.sendRedirect(this.oidcConfig().external_login());
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler xldLoginFailureHandler() {
        return new SimpleUrlAuthenticationFailureHandler();
    }

    @Bean
    @Autowired
    public OidcLogoutSuccessHandler openIdLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.oidcConfig().postLogoutRedirectUri(), "/login");
    }

    /*
     * WARNING - void declaration
     */
    private XlDeployLoginFormFilter buildLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        void var3_3;
        XlDeployLoginFormFilter filter = new XlDeployLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.xldLoginFailureHandler());
        return var3_3;
    }

    @Bean
    @Autowired
    public XlDeployLoginFormFilter defaultLoginFormFilter(AuthenticationManager authenticationManager, @Qualifier(value="defaultAuthenticationStrategy") SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        return this.buildLoginFormFilter(authenticationManager, sessionAuthenticationStrategy);
    }

    @Bean
    @Autowired
    public XlDeployLoginFormFilter csrfLoginFormFilter(AuthenticationManager authenticationManager, @Qualifier(value="csrfAuthenticationStrategy") SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        return this.buildLoginFormFilter(authenticationManager, sessionAuthenticationStrategy);
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> defaultOidcMustacheTemplateSettings() {
        void var1_1;
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "./images/xl-deploy-logo.svg");
        scope.put("productColor", "#0099cc");
        scope.put("productIcon", "./favicon.ico");
        scope.put("productName", "XL Deploy");
        return var1_1;
    }

    private ClientRegistration clientRegistration() {
        ClientRegistration.Builder clientRegistrationBuilder = this.getClientRegistrationBuilder();
        clientRegistrationBuilder.clientId(this.oidcConfig().clientId()).clientSecret(this.oidcConfig().clientSecret()).clientAuthenticationMethod(this.getClientAuthMethod()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUriTemplate(this.oidcConfig().redirectUri()).userInfoUri("").scope(new String[]{"openid"}).userNameAttributeName(this.oidcConfig().userNameClaimName());
        Object object = Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()) ? clientRegistrationBuilder.authorizationUri(this.oidcConfig().userAuthorizationUri()) : BoxedUnit.UNIT;
        Object object2 = Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()) ? clientRegistrationBuilder.tokenUri(this.oidcConfig().accessTokenUri()) : BoxedUnit.UNIT;
        Object object3 = Strings.isNotBlank((String)this.oidcConfig().jwks_uri()) ? clientRegistrationBuilder.jwkSetUri(this.oidcConfig().jwks_uri()) : BoxedUnit.UNIT;
        ClientRegistration clientRegistration = clientRegistrationBuilder.build();
        Map configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        HashMap<String, String> updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        updatedConfigurationMetadata.put("rolesClaim", this.oidcConfig().rolesClaimName());
        Object object4 = Strings.isNotBlank((String)this.oidcConfig().logoutUri()) ? updatedConfigurationMetadata.put("end_session_endpoint", this.oidcConfig().logoutUri()) : BoxedUnit.UNIT;
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        ClientRegistration.Builder builder;
        try {
            if (!this.oidcConfig().issuer().matches("\\S+")) {
                throw new UnsupportedOidcConfigurationException(new StringBuilder(148).append("Whitespace characters in issuer url [").append(this.oidcConfig().issuer()).append("] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.").toString());
            }
            builder = ClientRegistrations.fromOidcIssuerLocation((String)this.oidcConfig().issuer()).registrationId(this.oidcConfig().registrationId());
        }
        catch (RuntimeException re) {
            RuntimeException runtimeException = re;
            if (runtimeException instanceof IllegalArgumentException) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Unable to resolve Configuration with the provided Issuer of [").append(this.oidcConfig().issuer()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (runtimeException instanceof UnsupportedOidcConfigurationException) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> re.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)runtimeException);
            }
            this.validateOidcConfiguration();
            builder = ClientRegistration.withRegistrationId((String)this.oidcConfig().registrationId());
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private ClientHttpRequestFactory clientHttpRequestFactory() {
        void var1_1;
        block0: {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            if (!Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) break block0;
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        }
        return var1_1;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName) {
        scala.collection.immutable.Map jwsAlgorithms = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SignatureAlgorithm.values())).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)v.getName(), v), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MacAlgorithm.values())).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)v.getName(), v), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()));
        return (JwsAlgorithm)jwsAlgorithms.getOrElse((Object)jwsAlgorithm, (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(77).append(propertyName).append(" value [").append(jwsAlgorithm).append("] is not supported. Ensure you have configured a valid JWS Algorithm.").toString());
        });
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        scala.collection.immutable.Map clientAuthMethods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_basic"), (Object)ClientAuthenticationMethod.BASIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret_post"), (Object)ClientAuthenticationMethod.POST)}));
        return (ClientAuthenticationMethod)clientAuthMethods.getOrElse((Object)this.oidcConfig().clientAuthMethod().toLowerCase(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(108).append("clientAuthMethod value [").append(this.oidcConfig().clientAuthMethod()).append(" is not supported. Ensure you have configured a valid client authentication method.]").toString());
        });
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.oidcConfig().accessTokenIssuer()) ? this.oidcConfig().accessTokenIssuer() : this.oidcConfig().issuer()));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.oidcConfig().accessTokenAudience()) ? this.oidcConfig().accessTokenAudience() : this.oidcConfig().clientId())));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().userAuthorizationUri()), (String)OpenIdConnectConfig.getErrorMessage$1("xl.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().accessTokenUri()), (String)OpenIdConnectConfig.getErrorMessage$1("xl.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().jwks_uri()), (String)OpenIdConnectConfig.getErrorMessage$1("xl.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.oidcConfig().logoutUri()), (String)OpenIdConnectConfig.getErrorMessage$1("xl.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    private static final String getErrorMessage$1(String placeholder) {
        return new StringBuilder(41).append("No configuration setting found for key '").append(placeholder).append("'").toString();
    }

    public OpenIdConnectConfig() {
        Logging.$init$((Logging)this);
    }
}

