/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.typesafe.config.ConfigFactory;
import com.xebialabs.deployit.core.api.dto.LoginProvider;
import com.xebialabs.platform.sso.crypto.KeyRetriever;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToUserPolicy;
import com.xebialabs.platform.sso.oidc.userdetails.OpenIdConnectUserDetails;
import com.xebialabs.platform.sso.oidc.web.OpenIdConnectFilter;
import com.xebialabs.platform.sso.oidc.web.OpenIdLogoutSuccessHandler;
import com.xebialabs.xldeploy.auth.oidc.web.XlDeployLoginFormFilter;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xldeploy.authentication.oidc.conf.PeriodicKeyRetrieval$;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import scala.reflect.ScalaSignature;

@Configuration
@EnableOAuth2Client
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001=\u00111c\u00149f]&#7i\u001c8oK\u000e$8i\u001c8gS\u001eT!a\u0001\u0003\u0002\t\r|gN\u001a\u0006\u0003\u000b\u0019\tAa\\5eG*\u0011q\u0001C\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\tI!\"\u0001\u0005yY\u0012,\u0007\u000f\\8z\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u000bq\u0001A\u0011A\u000f\u0002#=LGm\u0019'pO&t\u0007K]8wS\u0012,'/F\u0001\u001f!\ty\u0002&D\u0001!\u0015\t\t#%A\u0002ei>T!a\t\u0013\u0002\u0007\u0005\u0004\u0018N\u0003\u0002&M\u0005!1m\u001c:f\u0015\t9#\"\u0001\u0005eKBdw._5u\u0013\tI\u0003EA\u0007M_\u001eLg\u000e\u0015:pm&$WM\u001d\u0015\u00037-\u0002\"\u0001L\u001b\u000e\u00035R!AL\u0018\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u00021c\u000591m\u001c8uKb$(B\u0001\u001a4\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\u001b\u0002\u0007=\u0014x-\u0003\u00027[\t!!)Z1o\u0011\u0015A\u0004\u0001\"\u0001\u001e\u0003IawnY1m\u0019><\u0017N\u001c)s_ZLG-\u001a:)\u0005]Z\u0003\"B\u001e\u0001\t\u0003a\u0014aE8qK:LEmQ8o]\u0016\u001cGOR5mi\u0016\u0014H#B\u001fI#n\u001b\u0007C\u0001 G\u001b\u0005y$B\u0001!B\u0003\r9XM\u0019\u0006\u0003\u000b\tS!a\u0011#\u0002\u0007M\u001cxN\u0003\u0002F\u0015\u0005A\u0001\u000f\\1uM>\u0014X.\u0003\u0002H\u007f\t\u0019r\n]3o\u0013\u0012\u001cuN\u001c8fGR4\u0015\u000e\u001c;fe\")\u0011J\u000fa\u0001\u0015\u0006)\u0012-\u001e;iK:$\u0018nY1uS>tW*\u00198bO\u0016\u0014\bCA&P\u001b\u0005a%BA\u0004N\u0015\tq\u0015'\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\u0001FJA\u000bBkRDWM\u001c;jG\u0006$\u0018n\u001c8NC:\fw-\u001a:\t\u000bIS\u0004\u0019A*\u0002'=\fU\u000f\u001e53\u00072LWM\u001c;D_:$X\r\u001f;\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016AB2mS\u0016tGO\u0003\u0002Y\u001b\u00061q.Y;uQJJ!AW+\u0003'=\u000bU\u000f\u001e53\u00072LWM\u001c;D_:$X\r\u001f;\t\u000bqS\u0004\u0019A/\u0002-\rd\u0017-[7t)>,6/\u001a:OC6,\u0007k\u001c7jGf\u0004\"AX1\u000e\u0003}S!\u0001Y!\u0002\rA|G.[2z\u0013\t\u0011wL\u0001\fDY\u0006LWn\u001d+p+N,'OT1nKB{G.[2z\u0011\u0015!'\b1\u0001f\u0003\u0001\u001aG.Y5ngR{wI]1oi\u0016$\u0017)\u001e;i_JLG/[3t!>d\u0017nY=\u0011\u0005y3\u0017BA4`\u0005\u0001\u001aE.Y5ngR{wI]1oi\u0016$\u0017)\u001e;i_JLG/[3t!>d\u0017nY=)\u0005iJ\u0007C\u00016q\u001b\u0005Y'B\u0001\u0018m\u0015\tig.A\u0004gC\u000e$xN]=\u000b\u0005=\f\u0014!\u00022fC:\u001c\u0018BA9l\u0005%\tU\u000f^8xSJ,G\r\u000b\u0002;W!)A\u000f\u0001C\u0001k\u0006qq\u000e]3o\u0013\u0012$V-\u001c9mCR,GC\u0001<z!\t!v/\u0003\u0002y+\n\u0011r*Q;uQJ\u0012Vm\u001d;UK6\u0004H.\u0019;f\u0011\u0015Q8\u000f1\u0001T\u0003My\u0017-\u001e;ie\rc\u0017.\u001a8u\u0007>tG/\u001a=u\u0011\u0015a\b\u0001\"\u0001~\u00035y\u0007/\u001a8JI\u0012+G/Y5mgV\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rQ+\u0001\u0005sKN|WO]2f\u0013\u0011\t9!!\u0001\u0003==\u000bU\u000f\u001e53!J|G/Z2uK\u0012\u0014Vm]8ve\u000e,G)\u001a;bS2\u001c\bFA>,\u0011\u0019a\u0006\u0001\"\u0001\u0002\u000eU\u0011\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC0\u0002\t%l\u0007\u000f\\\u0005\u0005\u00033\t\u0019BA\rEK\u001a\fW\u000f\u001c;DY\u0006LWn\u001d+p+N,'\u000fU8mS\u000eL\bfAA\u0006W!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012AC8jI\u000e\u001cuN\u001c4jOV\u0011\u00111\u0005\t\u00045\u0005\u0015\u0012bAA\u0014\u0005\tQq*\u001b3d\u0007>tg-[4)\u0007\u0005u1\u0006\u0003\u0004e\u0001\u0011\u0005\u0011QF\u000b\u0003\u0003_\u0001B!!\u0005\u00022%!\u00111GA\n\u0005\u001d\"UMZ1vYR\u001cE.Y5ngR{wI]1oi\u0016$\u0017)\u001e;i_JLG/[3t!>d\u0017nY=)\u0007\u0005-2\u0006C\u0004\u0002:\u0001!\t!a\u000f\u00025=\u0004XM\\%e\u0019><w.\u001e;Tk\u000e\u001cWm]:IC:$G.\u001a:\u0016\u0005\u0005u\u0002c\u0001 \u0002@%\u0019\u0011\u0011I \u00035=\u0003XM\\%e\u0019><w.\u001e;Tk\u000e\u001cWm]:IC:$G.\u001a:)\u0007\u0005]2\u0006C\u0004\u0002H\u0001!\t!!\u0013\u0002A1|w-\u001b8Ve2\fU\u000f\u001e5f]RL7-\u0019;j_:,e\u000e\u001e:z!>Lg\u000e^\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u000f\u0005E#B\u0001!N\u0013\u0011\t)&a\u0014\u0003A1{w-\u001b8Ve2\fU\u000f\u001e5f]RL7-\u0019;j_:,e\u000e\u001e:z!>Lg\u000e\u001e\u0015\u0004\u0003\u000bZ\u0003bBA.\u0001\u0011\u0005\u0011QL\u0001\u0017I\u00164\u0017-\u001e7u\u0019><\u0017N\u001c$pe64\u0015\u000e\u001c;feR1\u0011qLA8\u0003c\u0002B!!\u0019\u0002l5\u0011\u00111\r\u0006\u0004\u0001\u0006\u0015$bA\u0003\u0002h)\u0019\u0011\u0011\u000e\u0005\u0002\t\u0005,H\u000f[\u0005\u0005\u0003[\n\u0019GA\fYY\u0012+\u0007\u000f\\8z\u0019><\u0017N\u001c$pe64\u0015\u000e\u001c;fe\"1\u0011*!\u0017A\u0002)C\u0001\"a\u001d\u0002Z\u0001\u0007\u0011QO\u0001\u001eg\u0016\u001c8/[8o\u0003V$\b.\u001a8uS\u000e\fG/[8o'R\u0014\u0018\r^3hsB!\u0011qOA?\u001b\t\tIH\u0003\u0003\u0002|\u0005=\u0013aB:fgNLwN\\\u0005\u0005\u0003\u007f\nIHA\u000fTKN\u001c\u0018n\u001c8BkRDWM\u001c;jG\u0006$\u0018n\u001c8TiJ\fG/Z4zQ\r\tI&\u001b\u0015\u0004\u00033Z\u0003bBAD\u0001\u0011\u0005\u0011\u0011R\u0001$I\u00164\u0017-\u001e7u\u001f&$7-T;ti\u0006\u001c\u0007.\u001a+f[Bd\u0017\r^3TKR$\u0018N\\4t+\t\tY\t\u0005\u0005\u0002\u000e\u0006]\u00151TAN\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015\u0001B;uS2T!!!&\u0002\t)\fg/Y\u0005\u0005\u00033\u000byIA\u0002NCB\u0004B!!(\u0002,:!\u0011qTAT!\r\t\tKE\u0007\u0003\u0003GS1!!*\u000f\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0016\n\u0002\rA\u0013X\rZ3g\u0013\u0011\ti+a,\u0003\rM#(/\u001b8h\u0015\r\tIK\u0005\u0015\u0004\u0001\u0005M\u0006\u0003BA[\u0003\u0007l!!a.\u000b\t\u0005e\u00161X\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0007\u0001\u000biLC\u0002/\u0003\u007fS1!!1X\u0003\u0019\u0019wN\u001c4jO&!\u0011QYA\\\u0005I)e.\u00192mK>\u000bU\u000f\u001e53\u00072LWM\u001c;)\u0007\u0001\tI\rE\u0002-\u0003\u0017L1!!4.\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0002")
public class OpenIdConnectConfig {
    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), "." + this.oidcConfig().external_login(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    @Autowired
    public OpenIdConnectFilter openIdConnectFilter(AuthenticationManager authenticationManager, OAuth2ClientContext oAuth2ClientContext, ClaimsToUserNamePolicy claimsToUserNamePolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        KeyRetriever keyRetriever = new KeyRetriever(this.oidcConfig().jwks_uri());
        PeriodicKeyRetrieval$.MODULE$.setup(keyRetriever, this.oidcConfig().keyRetrieveSchedule());
        OpenIdConnectFilter filter = new OpenIdConnectFilter(this.oidcConfig().external_login(), this.oidcConfig().clientId(), this.oidcConfig().issuer(), this.openIdTemplate(oAuth2ClientContext), keyRetriever, claimsToUserNamePolicy, claimsToGrantedAuthoritiesPolicy);
        filter.setAuthenticationManager(authenticationManager);
        return filter;
    }

    public OAuth2RestTemplate openIdTemplate(OAuth2ClientContext oauth2ClientContext) {
        return new OAuth2RestTemplate(this.openIdDetails(), oauth2ClientContext);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public OAuth2ProtectedResourceDetails openIdDetails() {
        void var1_1;
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        details.setClientId(this.oidcConfig().clientId());
        details.setClientSecret(this.oidcConfig().clientSecret());
        details.setAccessTokenUri(this.oidcConfig().accessTokenUri());
        details.setUserAuthorizationUri(this.oidcConfig().userAuthorizationUri());
        details.setScope(Collections.singletonList("openid"));
        details.setPreEstablishedRedirectUri(this.oidcConfig().redirectUri());
        details.setUseCurrentUri(false);
        details.setClientAuthenticationScheme(AuthenticationScheme.form);
        return var1_1;
    }

    @Bean
    public DefaultClaimsToUserPolicy claimsToUserNamePolicy() {
        return new DefaultClaimsToUserPolicy(this.oidcConfig().userNameClaimName());
    }

    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigFactory.load((String)"auth-oidc.conf"));
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    public OpenIdLogoutSuccessHandler openIdLogoutSuccessHandler() {
        return new OpenIdLogoutSuccessHandler(this){
            private final /* synthetic */ OpenIdConnectConfig $outer;

            public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
                block0: {
                    super.onLogoutSuccess(request, response, authentication);
                    if (authentication != null && authentication.getDetails() instanceof OpenIdConnectUserDetails) break block0;
                    response.sendRedirect(request.getContextPath() + this.$outer.loginUrlAuthenticationEntryPoint().getLoginFormUrl());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.oidcConfig().logoutUri());
            }
        };
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    @Autowired
    public XlDeployLoginFormFilter defaultLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        void var3_3;
        XlDeployLoginFormFilter filter = new XlDeployLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> defaultOidcMustacheTemplateSettings() {
        void var1_1;
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "./images/xl-deploy-logo.svg");
        scope.put("productColor", "#0099cc");
        scope.put("productIcon", "./favicon.ico");
        scope.put("productName", "XL Deploy");
        return var1_1;
    }
}

