/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.core.api.dto.LoginProvider;
import com.xebialabs.deployit.spring.HoconPropertySourceFactory;
import com.xebialabs.platform.sso.crypto.KeyRetriever;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToUserPolicy;
import com.xebialabs.platform.sso.oidc.userdetails.OpenIdConnectUserDetails;
import com.xebialabs.platform.sso.oidc.web.OpenIdConnectFilter;
import com.xebialabs.platform.sso.oidc.web.OpenIdLogoutSuccessHandler;
import com.xebialabs.xldeploy.auth.oidc.web.XlDeployLoginFormFilter;
import com.xebialabs.xldeploy.authentication.oidc.conf.OidcConfig;
import com.xebialabs.xldeploy.authentication.oidc.conf.PeriodicKeyRetrieval$;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitAccessTokenProvider;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@Configuration
@EnableOAuth2Client
@PropertySource(factory=HoconPropertySourceFactory.class, value={"conf/xl-deploy.conf"})
@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001B\t\u0013\u0001}AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-BQ\u0001\u0010\u0001\u0005\u0002uBQa\u0013\u0001\u0005\u0002uBQ!\u0014\u0001\u0005\u00029Cq!a\u0003\u0001\t\u0003\ti\u0001\u0003\u0004o\u0001\u0011\u0005\u0011Q\u0004\u0005\u0007m\u0002!\t!!\f\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a*\u0001\t\u0003\tI\u000bC\u0004\u00026\u0002!I!a.\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\n\u0019r\n]3o\u0013\u0012\u001cuN\u001c8fGR\u001cuN\u001c4jO*\u00111\u0003F\u0001\u0005G>tgM\u0003\u0002\u0016-\u0005!q.\u001b3d\u0015\t9\u0002$\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005eQ\u0012\u0001\u0003=mI\u0016\u0004Hn\\=\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011C\u0001\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AE\u0001\u000b_&$7mQ8oM&<W#\u0001\u0017\u0011\u0005%j\u0013B\u0001\u0018\u0013\u0005)y\u0015\u000eZ2D_:4\u0017n\u001a\u0015\u0003\u0005A\u0002\"!\r\u001e\u000e\u0003IR!a\r\u001b\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u00026m\u000591m\u001c8uKb$(BA\u001c9\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u001d\u0002\u0007=\u0014x-\u0003\u0002<e\t!!)Z1o\u0003Ey\u0017\u000eZ2M_\u001eLg\u000e\u0015:pm&$WM]\u000b\u0002}A\u0011q\bS\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0004IR|'BA\"E\u0003\r\t\u0007/\u001b\u0006\u0003\u000b\u001a\u000bAaY8sK*\u0011qIG\u0001\tI\u0016\u0004Hn\\=ji&\u0011\u0011\n\u0011\u0002\u000e\u0019><\u0017N\u001c)s_ZLG-\u001a:)\u0005\r\u0001\u0014A\u00057pG\u0006dGj\\4j]B\u0013xN^5eKJD#\u0001\u0002\u0019\u0002'=\u0004XM\\%e\u0007>tg.Z2u\r&dG/\u001a:\u0015\u000b=S6-\\;\u0011\u0005ACV\"A)\u000b\u0005I\u001b\u0016aA<fE*\u0011Q\u0003\u0016\u0006\u0003+Z\u000b1a]:p\u0015\t9&$\u0001\u0005qY\u0006$hm\u001c:n\u0013\tI\u0016KA\nPa\u0016t\u0017\nZ\"p]:,7\r\u001e$jYR,'\u000fC\u0003\\\u000b\u0001\u0007A,A\u000bbkRDWM\u001c;jG\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0005u\u000bW\"\u00010\u000b\u0005]y&B\u000117\u0003!\u0019XmY;sSRL\u0018B\u00012_\u0005U\tU\u000f\u001e5f]RL7-\u0019;j_:l\u0015M\\1hKJDQ\u0001Z\u0003A\u0002\u0015\f1c\\!vi\"\u00144\t\\5f]R\u001cuN\u001c;fqR\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\r\rd\u0017.\u001a8u\u0015\tQw,\u0001\u0004pCV$\bNM\u0005\u0003Y\u001e\u00141cT!vi\"\u00144\t\\5f]R\u001cuN\u001c;fqRDQA\\\u0003A\u0002=\fac\u00197bS6\u001cHk\\+tKJt\u0015-\\3Q_2L7-\u001f\t\u0003aNl\u0011!\u001d\u0006\u0003eN\u000ba\u0001]8mS\u000eL\u0018B\u0001;r\u0005Y\u0019E.Y5ngR{Wk]3s\u001d\u0006lW\rU8mS\u000eL\b\"\u0002<\u0006\u0001\u00049\u0018\u0001I2mC&l7\u000fV8He\u0006tG/\u001a3BkRDwN]5uS\u0016\u001c\bk\u001c7jGf\u0004\"\u0001\u001d=\n\u0005e\f(\u0001I\"mC&l7\u000fV8He\u0006tG/\u001a3BkRDwN]5uS\u0016\u001c\bk\u001c7jGfD#!B>\u0011\u0007q\f)!D\u0001~\u0015\t\u0019dPC\u0002\u0000\u0003\u0003\tqAZ1di>\u0014\u0018PC\u0002\u0002\u0004Y\nQAY3b]NL1!a\u0002~\u0005%\tU\u000f^8xSJ,G\r\u000b\u0002\u0006a\u0005iq\u000e]3o\u0013\u0012$U\r^1jYN,\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006h\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BA\r\u0003'\u0011adT!vi\"\u0014\u0004K]8uK\u000e$X\r\u001a*fg>,(oY3EKR\f\u0017\u000e\\:)\u0005\u0019\u0001TCAA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013c\u0006!\u0011.\u001c9m\u0013\u0011\tI#a\t\u00033\u0011+g-Y;mi\u000ec\u0017-[7t)>,6/\u001a:Q_2L7-\u001f\u0015\u0003\u000fA*\"!a\f\u0011\t\u0005\u0005\u0012\u0011G\u0005\u0005\u0003g\t\u0019CA\u0014EK\u001a\fW\u000f\u001c;DY\u0006LWn\u001d+p\u000fJ\fg\u000e^3e\u0003V$\bn\u001c:ji&,7\u000fU8mS\u000eL\bF\u0001\u00051\u0003iy\u0007/\u001a8JI2{wm\\;u'V\u001c7-Z:t\u0011\u0006tG\r\\3s+\t\tY\u0004E\u0002Q\u0003{I1!a\u0010R\u0005iy\u0005/\u001a8JI2{wm\\;u'V\u001c7-Z:t\u0011\u0006tG\r\\3sQ\tI\u0001'\u0001\u000bck&dG\rT8hS:4uN]7GS2$XM\u001d\u000b\u0007\u0003\u000f\n9&!\u0017\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017R1AUA'\u0015\r)\u0012q\n\u0006\u0004\u0003#B\u0012\u0001B1vi\"LA!!\u0016\u0002L\t9\u0002\f\u001c#fa2|\u0017\u0010T8hS:4uN]7GS2$XM\u001d\u0005\u00067*\u0001\r\u0001\u0018\u0005\b\u00037R\u0001\u0019AA/\u0003u\u0019Xm]:j_:\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cFO]1uK\u001eL\b\u0003BA0\u0003Sj!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\bg\u0016\u001c8/[8o\u0015\r9\u0012q\r\u0006\u0003%~KA!a\u001b\u0002b\ti2+Z:tS>t\u0017)\u001e;iK:$\u0018nY1uS>t7\u000b\u001e:bi\u0016<\u00170\u0001\feK\u001a\fW\u000f\u001c;M_\u001eLgNR8s[\u001aKG\u000e^3s)\u0019\t9%!\u001d\u0002t!)1l\u0003a\u00019\"9\u00111L\u0006A\u0002\u0005u\u0003\u0006CA:\u0003o\ni(a \u0011\u0007q\fI(C\u0002\u0002|u\u0014\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0005\u0005\u0005\u0015!\b3fM\u0006,H\u000e^!vi\",g\u000e^5dCRLwN\\*ue\u0006$XmZ=)\u0005-Y\bFA\u00061\u0003M\u00197O\u001d4M_\u001eLgNR8s[\u001aKG\u000e^3s)\u0019\t9%a#\u0002\u000e\")1\f\u0004a\u00019\"9\u00111\f\u0007A\u0002\u0005u\u0003\u0006CAG\u0003o\ni(!%\"\u0005\u0005M\u0015AG2te\u001a\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cFO]1uK\u001eL\bF\u0001\u0007|Q\ta\u0001'\u0001\u0011m_\u001eLg.\u0016:m\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000b:$(/\u001f)pS:$XCAAO!\u0011\ty*!)\u000e\u0005\u0005\u0015\u0014\u0002BAR\u0003K\u0012\u0001\u0005T8hS:,&\u000f\\!vi\",g\u000e^5dCRLwN\\#oiJL\bk\\5oi\"\u0012Q\u0002M\u0001\u000f_B,g.\u00133UK6\u0004H.\u0019;f)\u0011\tY+!-\u0011\u0007\u0019\fi+C\u0002\u00020\u001e\u0014!cT!vi\"\u0014$+Z:u)\u0016l\u0007\u000f\\1uK\"1\u00111\u0017\bA\u0002\u0015\f1c\\1vi\"\u00144\t\\5f]R\u001cuN\u001c;fqR\f\u0001b]3u!J|\u00070\u001f\u000b\u0005\u0003s\u000by\fE\u0002\"\u0003wK1!!0#\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005w\u00021\u0001\u0002,\u0006\u0011r.Q;uQJ\u0012Vm\u001d;UK6\u0004H.\u0019;f\u0003\r\"WMZ1vYR|\u0015\u000eZ2NkN$\u0018m\u00195f)\u0016l\u0007\u000f\\1uKN+G\u000f^5oON,\"!a2\u0011\u0011\u0005%\u00171[Al\u0003/l!!a3\u000b\t\u00055\u0017qZ\u0001\u0005kRLGN\u0003\u0002\u0002R\u0006!!.\u0019<b\u0013\u0011\t).a3\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002Z\u0006\u001dh\u0002BAn\u0003G\u00042!!8#\u001b\t\tyNC\u0002\u0002bz\ta\u0001\u0010:p_Rt\u0014bAAsE\u00051\u0001K]3eK\u001aLA!!;\u0002l\n11\u000b\u001e:j]\u001eT1!!:#Q)\u0001\u0011q^@\u0002v\u0006u$1\u0001\t\u0004c\u0005E\u0018bAAze\tq\u0001K]8qKJ$\u0018pU8ve\u000e,7EAA|!\u0011\tI0a@\u000e\u0005\u0005m(bAA\u007f\r\u000611\u000f\u001d:j]\u001eLAA!\u0001\u0002|\nQ\u0002j\\2p]B\u0013x\u000e]3sif\u001cv.\u001e:dK\u001a\u000b7\r^8ss2\u0012!QA\u0011\u0003\u0005\u000f\t1cY8oM>BH.\f3fa2|\u0017PL2p]\u001aD3\u0001\u0001B\u0006!\u0011\u0011iAa\u0007\u000e\u0005\t=!\u0002\u0002B\t\u0005'\tQbY8oM&<WO]1uS>t'b\u0001*\u0003\u0016)\u00191Ga\u0006\u000b\u0007\te\u0011.\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0005;\u0011yA\u0001\nF]\u0006\u0014G.Z(BkRD'g\u00117jK:$\bf\u0001\u0001\u0003\"A\u0019\u0011Ga\t\n\u0007\t\u0015\"GA\u0007D_:4\u0017nZ;sCRLwN\u001c")
public class OpenIdConnectConfig {
    @Bean
    public OidcConfig oidcConfig() {
        return new OidcConfig(ConfigLoader$.MODULE$.loadWithDynamic("xl-deploy.conf"));
    }

    @Bean
    public LoginProvider oidcLoginProvider() {
        return new LoginProvider(this.oidcConfig().loginMethodDescription(), new StringBuilder(1).append(".").append(this.oidcConfig().external_login()).toString(), "./logout", false);
    }

    @Bean
    public LoginProvider localLoginProvider() {
        return new LoginProvider("XL Deploy local login", "./login", "./logout", true);
    }

    @Bean
    @Autowired
    public OpenIdConnectFilter openIdConnectFilter(AuthenticationManager authenticationManager, OAuth2ClientContext oAuth2ClientContext, ClaimsToUserNamePolicy claimsToUserNamePolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        KeyRetriever keyRetriever = new KeyRetriever(this.oidcConfig().jwks_uri());
        if (Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) {
            keyRetriever.setProxy(this.oidcConfig().proxyHost(), this.oidcConfig().proxyPort());
        }
        PeriodicKeyRetrieval$.MODULE$.setup(keyRetriever, this.oidcConfig().keyRetrieveSchedule());
        OpenIdConnectFilter filter = new OpenIdConnectFilter(this.oidcConfig().external_login(), this.oidcConfig().clientId(), this.oidcConfig().issuer(), this.openIdTemplate(oAuth2ClientContext), keyRetriever, claimsToUserNamePolicy, claimsToGrantedAuthoritiesPolicy);
        filter.setAuthenticationManager(authenticationManager);
        return filter;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public OAuth2ProtectedResourceDetails openIdDetails() {
        void var1_1;
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        details.setClientId(this.oidcConfig().clientId());
        details.setClientSecret(this.oidcConfig().clientSecret());
        details.setAccessTokenUri(this.oidcConfig().accessTokenUri());
        details.setUserAuthorizationUri(this.oidcConfig().userAuthorizationUri());
        details.setScope(this.oidcConfig().scopes());
        details.setPreEstablishedRedirectUri(this.oidcConfig().redirectUri());
        details.setUseCurrentUri(false);
        details.setClientAuthenticationScheme(AuthenticationScheme.form);
        return var1_1;
    }

    @Bean
    public DefaultClaimsToUserPolicy claimsToUserNamePolicy() {
        return new DefaultClaimsToUserPolicy(this.oidcConfig().userNameClaimName());
    }

    @Bean
    public DefaultClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.oidcConfig().rolesClaimName());
    }

    @Bean
    public OpenIdLogoutSuccessHandler openIdLogoutSuccessHandler() {
        return new OpenIdLogoutSuccessHandler(this){
            private final /* synthetic */ OpenIdConnectConfig $outer;

            public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
                block0: {
                    super.onLogoutSuccess(request, response, authentication);
                    if (authentication != null && authentication.getDetails() instanceof OpenIdConnectUserDetails) break block0;
                    response.sendRedirect(new StringBuilder(0).append(request.getContextPath()).append(this.$outer.loginUrlAuthenticationEntryPoint().getLoginFormUrl()).toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.oidcConfig().logoutUri());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private XlDeployLoginFormFilter buildLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        void var3_3;
        XlDeployLoginFormFilter filter = new XlDeployLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        return var3_3;
    }

    @Bean
    @Autowired
    public XlDeployLoginFormFilter defaultLoginFormFilter(AuthenticationManager authenticationManager, @Qualifier(value="defaultAuthenticationStrategy") SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        return this.buildLoginFormFilter(authenticationManager, sessionAuthenticationStrategy);
    }

    @Bean
    @Autowired
    public XlDeployLoginFormFilter csrfLoginFormFilter(AuthenticationManager authenticationManager, @Qualifier(value="csrfAuthenticationStrategy") SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        return this.buildLoginFormFilter(authenticationManager, sessionAuthenticationStrategy);
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new LoginUrlAuthenticationEntryPoint(this.oidcConfig().external_login());
    }

    /*
     * WARNING - void declaration
     */
    public OAuth2RestTemplate openIdTemplate(OAuth2ClientContext oauth2ClientContext) {
        void var2_2;
        block0: {
            OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate(this.openIdDetails(), oauth2ClientContext);
            if (!Strings.isNotEmpty((String)this.oidcConfig().proxyHost())) break block0;
            this.setProxy(oAuth2RestTemplate);
        }
        return var2_2;
    }

    private void setProxy(OAuth2RestTemplate oAuth2RestTemplate) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.oidcConfig().proxyHost(), Predef$.MODULE$.Integer2int(this.oidcConfig().proxyPort()))));
        AuthorizationCodeAccessTokenProvider authorizationCodeAccessTokenProvider = new AuthorizationCodeAccessTokenProvider();
        authorizationCodeAccessTokenProvider.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        ImplicitAccessTokenProvider implicitAccessTokenProvider = new ImplicitAccessTokenProvider();
        implicitAccessTokenProvider.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        AccessTokenProviderChain accessTokenProvider = new AccessTokenProviderChain(Arrays.asList((Object[])new AccessTokenProvider[]{authorizationCodeAccessTokenProvider, implicitAccessTokenProvider}));
        oAuth2RestTemplate.setAccessTokenProvider((AccessTokenProvider)accessTokenProvider);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> defaultOidcMustacheTemplateSettings() {
        void var1_1;
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "./images/xl-deploy-logo.svg");
        scope.put("productColor", "#0099cc");
        scope.put("productIcon", "./favicon.ico");
        scope.put("productName", "XL Deploy");
        return var1_1;
    }
}

