/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.ec2.support;

import de.schlichtherle.truezip.file.TFile;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BotoLoader {
    public static List<String> listAvailableServices() throws Exception {
        ArrayList<String> availableServices = new ArrayList<String>();
        List<TFile> tFiles = BotoLoader.serviceDir();
        for (TFile tFile : tFiles) {
            availableServices.add(tFile.getName());
        }
        Collections.sort(availableServices);
        return availableServices;
    }

    private static List<TFile> serviceDir() throws Exception {
        ArrayList<TFile> tFiles = new ArrayList<TFile>();
        URL url = BotoLoader.class.getClassLoader().getResource("boto3/data");
        TFile tFile = new TFile(url.toURI());
        TFile[] listFiles = tFile.listFiles();
        tFiles.addAll(Arrays.asList(listFiles));
        return tFiles;
    }

    public static List<String> listApiVersion(String serviceName, String typeName) throws Exception {
        List<TFile> tFiles = BotoLoader.serviceDir();
        ArrayList<String> apiVersions = new ArrayList<String>();
        for (TFile tFile : tFiles) {
            if (!tFile.getName().equals(serviceName)) continue;
            apiVersions.addAll(Arrays.asList(tFile.list()));
        }
        return apiVersions;
    }

    public static String fullpath(String name) throws Exception {
        URL url = BotoLoader.class.getClassLoader().getResource("boto3/data");
        TFile tFile = new TFile(url.toURI());
        return tFile.getPath() + name;
    }

    public static String loadFile(String name) throws Exception {
        String unixName = name.replace("\\", "/");
        unixName = unixName + ".json";
        String resourceName = "boto3/data/" + unixName;
        URL url = BotoLoader.class.getClassLoader().getResource(resourceName);
        if (url == null) {
            url = BotoLoader.class.getClassLoader().getResource("botocore/data/" + unixName);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        URI uri = url.toURI();
        new TFile(uri).output((OutputStream)out);
        String content = out.toString();
        return content;
    }
}

