from alb.alb_helper import ALBHelper

alb_helper = ALBHelper(deployed, previousDeployed)
load_balancer_name = deployed.loadBalancerName if deployed.loadBalancerName else deployed.name

#Validate alb modification
alb_helper.validate_alb_modification()

# Configure application alb
if alb_helper.should_modify_alb():
    # Validate properties
    alb_helper.validate_alb()
    context.addStep(steps.jython(
        description="Configure application ELB {} on {}".format(load_balancer_name, deployed.container.name),
        script="alb/steps/configure_alb.py",
        order=87
    ))

# Create listeners
if deployed.listeners:
    # Validate listeners
    alb_helper.validate_listeners()
    context.addStep(steps.jython(
        description="Create listeners for application ELB {} on {}".format(load_balancer_name, deployed.container.name),
        script="alb/steps/create_listeners.py",
        order=87
    ))

# Create listener rules
if deployed.listenerRules:
    # Validate rules
    alb_helper.validate_listener_rules()
    context.addStep(steps.jython(
        description="Create listener rules for application ELB {} on {}".format(load_balancer_name, deployed.container.name),
        script="alb/steps/create_listener_rules.py",
        order=88
    ))

# Associate resources
if  alb_helper.should_associate_resources():
    context.addStep(steps.jython(
        description="Associate resources to application ELB {} on {}".format(load_balancer_name, deployed.container.name),
        script="alb/steps/associate_resources.py",
        order=87
    ))

# Dissociate resources
if alb_helper.should_dissociate_resources():
    context.addStep(steps.jython(
        description="Dissociate resources from application ELB {} on {}".format(load_balancer_name, deployed.container.name),
        script="alb/steps/dissociate_resources.py",
        order=19
    ))

    context.addStep(steps.jython(
        description="Wait for resources to be dissociated completely from application ELB {} on {}".format(load_balancer_name, deployed.container.name),
        script="alb/steps/wait_resources_dissociate.py",
        order=20
    ))

# Destroy listener rules
if previousDeployed.listenerRules:
    context.addStep(steps.jython(
        description="Destroy listener rules in application ELB {} on {}".format(load_balancer_name, deployed.container.name),
        script="alb/steps/destroy_listener_rules.py",
        order=13
    ))

# Destroy listeners
if previousDeployed.listeners:
    context.addStep(steps.jython(
        description="Destroy listeners in application ELB {} on {}".format(deployed.loadBalancerName, deployed.container.name),
        script="alb/steps/destroy_listeners.py",
        order=14
    ))
