from ecs import ECSHelper


class ECSClusterHelper(ECSHelper):
    def __init__(self, deployed):
        super(ECSClusterHelper, self).__init__(deployed)

    def create_cluster(self):
        cluster_name = self.deployed.clusterName if self.deployed.clusterName else self.deployed.name
        print "Creating ECS cluster {0}".format(cluster_name)
        response = self.ecs_client.create_cluster(clusterName=cluster_name)
        return response['cluster']['clusterArn']

    def remove_cluster(self):
        print "Destroying ECS cluster {0}".format(self.deployed.clusterName if self.deployed.clusterName else self.deployed.name)
        return self.ecs_client.delete_cluster(cluster=self.deployed.clusterArn)

    def get_cluster_details(self):
        response = self.ecs_client.describe_clusters(clusters=[self.deployed.clusterArn])
        return response['clusters'][0]

    def get_registered_container_instances_count(self):
        return self.get_cluster_details()['registeredContainerInstancesCount']

    def get_cluster_status(self):
        return self.get_cluster_details()['status']

    def get_running_tasks_count(self):
        return self.get_cluster_details()['runningTasksCount']

    def get_active_services_count(self):
        return self.get_cluster_details()['activeServicesCount']

    def is_any_service_task_running(self):
        return self.get_active_services_count() > 0 or self.get_running_tasks_count() > 0
