from auto_scaling.group.builders.asg_builder import AsgParamsBuilder
from auto_scaling.group.helpers.core_helper import AutoScalingGroupHelper
from auto_scaling.group.helpers.elb_helper import ElbHelper
from auto_scaling.group.helpers.target_group_helper import ASGTargetGroupHelper
from auto_scaling.group.validator import AutoScalingValidator
from auto_scaling.launch_configuration.helper import LaunchConfigHelper

sg_helper = AutoScalingGroupHelper(deployed, previousDeployed)
lc_helper = LaunchConfigHelper(deployed, previousDeployed)
validator = AutoScalingValidator(deployed, previousDeployed)
tg_helper = ASGTargetGroupHelper(deployed, previousDeployed)
elb_helper = ElbHelper(deployed, previousDeployed)

if validator.is_instance_image_details_changed():
    lc_helper.create(version_id)
    lc_helper.save_arn()
    lc_update_params = AsgParamsBuilder(deployed).with_auto_scale_group_name().with_launch_config_name().build()
    print "Updating launch configuration {0} on auto scaling group {1} on {2}".format(
        deployed.launchConfigurationName,
        sg_helper.get_asg_name(),
        deployed.container.name)

    sg_helper.update(lc_update_params)
    lc_helper.delete()

if elb_helper.are_new_load_balancers_attached():
    elb_helper.attach_load_balancers()

if tg_helper.are_new_target_groups_attached():
    tg_helper.attach_target_groups()
