from auto_scaling import *
from auto_scaling.group.helpers.core_helper import AutoScalingGroupHelper
from commons.aws_helper import AWSHelper


class ElbHelper(AWSHelper):
    def __init__(self, deployed, previous_deployed=None):
        super(ElbHelper, self).__init__(deployed)
        self.__client = self.get_aws_client(region=deployed.region, resource_name='autoscaling')
        self.__previous_deployed = previous_deployed
        self.__asg_helper = AutoScalingGroupHelper(deployed)

    def detach_load_balancers(self):
        detached_load_balancers = self.get_detached_load_balancers()
        print "Detaching load balancers {0} from auto scaling group {1} on {2}".format(
            get_formatted_string(detached_load_balancers),
            self.__asg_helper.get_asg_name(),
            self.deployed.container.name)
        return self.__client.detach_load_balancers(
            AutoScalingGroupName=self.__asg_helper.get_asg_name(),
            LoadBalancerNames=list(detached_load_balancers)
        )

    def attach_load_balancers(self):
        attached_load_balancers = self.get_new_attached_load_balancers()
        print "Adding load balancers {0} to auto scaling group {1} on {2}".format(
            get_formatted_string(attached_load_balancers),
            self.__asg_helper.get_asg_name(),
            self.deployed.container.name)
        return self.__client.attach_load_balancers(
            AutoScalingGroupName=self.__asg_helper.get_asg_name(),
            LoadBalancerNames=list(attached_load_balancers)
        )

    def are_new_load_balancers_attached(self):
        return bool(self.get_new_attached_load_balancers())

    def get_new_attached_load_balancers(self):
        return (self.deployed.loadBalancerNames - self.__previous_deployed.loadBalancerNames) if bool(
            self.__previous_deployed) else self.deployed.loadBalancerNames

    def are_load_balancers_detached(self):
        return bool(self.get_detached_load_balancers())

    def get_detached_load_balancers(self):
        return self.__previous_deployed.loadBalancerNames - self.deployed.loadBalancerNames
